/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.updatechecker;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateListProperties {
    private static final Logger log = LoggerFactory.getLogger(UpdateListProperties.class);
    private static final Splitter SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private final Properties properties = new Properties();

    public UpdateListProperties(URL updateCheckURL, int connectionTimeout) {
        try {
            this.loadUpdateListProperties(updateCheckURL, connectionTimeout);
        }
        catch (IOException e) {
            log.debug("Unable to load update list properties", (Throwable)e);
        }
    }

    public String getGeneralNotice() {
        return this.getProperty("general.notice");
    }

    public String getNoticeForVersion(String version) {
        return this.getProperty(version + ".notice");
    }

    public List<String> getUpdatesForVersion(String version) {
        String updates = this.getProperty(version + ".updates");
        return updates == null ? ImmutableList.of() : SPLITTER.splitToList((CharSequence)updates);
    }

    public String getReleaseNotesForVersion(String version) {
        return this.getProperty(version + ".release-notes");
    }

    private String getProperty(String key) {
        return this.getSanitizedString(this.properties.getProperty(key));
    }

    private String getSanitizedString(String string) {
        return Strings.isNullOrEmpty((String)string) ? null : string.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUpdateListProperties(URL updateCheckURL, int connectionTimeout) throws IOException {
        log.debug("Checking {} for updates", (Object)updateCheckURL.toExternalForm());
        URLConnection connection = updateCheckURL.openConnection();
        connection.setConnectTimeout(connectionTimeout);
        try (InputStream in = connection.getInputStream();){
            this.properties.load(in);
        }
    }
}

