/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.healthchecks;

import com.codahale.metrics.health.HealthCheck;
import com.google.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.osgi.api.Healthcheck;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KillbillPluginsHealthcheck
extends HealthCheck {
    private static final Logger logger = LoggerFactory.getLogger(KillbillPluginsHealthcheck.class);
    private OSGIServiceRegistration<Healthcheck> pluginHealthchecks = null;

    @Inject(optional=true)
    public void setPluginHealthchecks(OSGIServiceRegistration<Healthcheck> pluginHealthchecks) {
        this.pluginHealthchecks = pluginHealthchecks;
    }

    public HealthCheck.Result check() {
        HealthCheck.ResultBuilder resultBuilder = HealthCheck.Result.builder();
        boolean isHealthy = true;
        if (this.pluginHealthchecks != null) {
            for (String pluginHealthcheckService : this.pluginHealthchecks.getAllServices()) {
                Healthcheck pluginHealthcheck = (Healthcheck)this.pluginHealthchecks.getServiceForName(pluginHealthcheckService);
                if (pluginHealthcheck == null) continue;
                Healthcheck.HealthStatus pluginStatus = pluginHealthcheck.getHealthStatus(null, null);
                resultBuilder.withDetail(pluginHealthcheckService, (Object)pluginStatus.getDetails());
                isHealthy = isHealthy && pluginStatus.isHealthy();
            }
        }
        return isHealthy ? resultBuilder.healthy().build() : resultBuilder.unhealthy().build();
    }
}

