/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.filters;

import com.google.inject.Injector;
import com.google.inject.servlet.GuiceFilter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.killbill.billing.server.healthchecks.KillbillHealthcheck;
import org.killbill.billing.server.updatechecker.UpdateChecker;
import org.skife.config.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillbillGuiceFilter
extends GuiceFilter {
    private static final Logger log = LoggerFactory.getLogger(KillbillGuiceFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        log.info("Kill Bill server has started");
        Injector injector = (Injector)filterConfig.getServletContext().getAttribute(Injector.class.getName());
        ConfigSource configSource = (ConfigSource)injector.getInstance(ConfigSource.class);
        UpdateChecker checker = new UpdateChecker(configSource);
        checker.check(filterConfig.getServletContext());
        KillbillHealthcheck killbillHealthcheck = (KillbillHealthcheck)injector.getInstance(KillbillHealthcheck.class);
        killbillHealthcheck.putInRotation();
    }
}

