/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.healthchecks;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.killbill.billing.osgi.api.ServiceDiscoveryRegistry;
import org.killbill.commons.health.api.HealthCheck;
import org.killbill.commons.health.api.Result;
import org.killbill.commons.health.impl.HealthyResultBuilder;
import org.killbill.commons.health.impl.UnhealthyResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weakref.jmx.Managed;

@Singleton
public class KillbillHealthcheck
implements HealthCheck {
    private static final Logger logger = LoggerFactory.getLogger(KillbillHealthcheck.class);
    private static final String OK = "OK";
    private static final String OUT_OF_ROTATION = "Out of rotation";
    private final AtomicBoolean outOfRotation = new AtomicBoolean(true);
    private Set<ServiceDiscoveryRegistry> serviceDiscoveryRegistries = Collections.emptySet();
    private OSGIServiceRegistration<ServiceDiscoveryRegistry> pluginServiceDiscoveryRegistries = null;

    @Inject
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setServiceDiscoveryRegistries(@Nullable Set<ServiceDiscoveryRegistry> serviceDiscoveryRegistries) {
        this.serviceDiscoveryRegistries = serviceDiscoveryRegistries;
    }

    @Inject
    public void setPluginServiceDiscoveryRegistries(@Nullable OSGIServiceRegistration<ServiceDiscoveryRegistry> pluginServiceDiscoveryRegistries) {
        this.pluginServiceDiscoveryRegistries = pluginServiceDiscoveryRegistries;
    }

    public Result check() {
        if (this.outOfRotation.get()) {
            return this.buildHealthcheckResponse(false, OUT_OF_ROTATION);
        }
        return this.buildHealthcheckResponse(true, OK);
    }

    @Managed(description="Basic killbill healthcheck")
    public boolean isHealthy() {
        return this.check().isHealthy();
    }

    @Managed(description="Put in rotation")
    public void putInRotation() {
        logger.warn("Putting host in rotation");
        this.outOfRotation.set(false);
        for (ServiceDiscoveryRegistry serviceDiscoveryRegistry : this.serviceDiscoveryRegistries) {
            logger.info("Registering ServiceDiscoveryRegistry {}", (Object)serviceDiscoveryRegistry);
            try {
                serviceDiscoveryRegistry.register();
            }
            catch (RuntimeException e) {
                logger.warn("Failed to register ServiceDiscoveryRegistry {}. Exception: {}", (Object)serviceDiscoveryRegistry, (Object)e);
            }
        }
        if (this.pluginServiceDiscoveryRegistries != null) {
            for (String pluginServiceDiscoveryRegistryService : this.pluginServiceDiscoveryRegistries.getAllServices()) {
                ServiceDiscoveryRegistry pluginServiceDiscoveryRegistry = (ServiceDiscoveryRegistry)this.pluginServiceDiscoveryRegistries.getServiceForName(pluginServiceDiscoveryRegistryService);
                if (pluginServiceDiscoveryRegistry == null) continue;
                logger.info("Registering Plugin ServiceDiscoveryRegistry {}", (Object)pluginServiceDiscoveryRegistry);
                try {
                    pluginServiceDiscoveryRegistry.register();
                }
                catch (RuntimeException e) {
                    logger.warn("Failed to register Plugin ServiceDiscoveryRegistry {}. Exception: {}", (Object)pluginServiceDiscoveryRegistry, (Object)e);
                }
            }
        }
    }

    @Managed(description="Put out of rotation")
    public void putOutOfRotation() {
        logger.warn("Putting host out of rotation");
        this.outOfRotation.set(true);
        for (ServiceDiscoveryRegistry serviceDiscoveryRegistry : this.serviceDiscoveryRegistries) {
            logger.info("Unregistering ServiceDiscoveryRegistry {}", (Object)serviceDiscoveryRegistry);
            try {
                serviceDiscoveryRegistry.unregister();
            }
            catch (RuntimeException e) {
                logger.warn("Failed to unregister ServiceDiscoveryRegistry {}. Exception: {}", (Object)serviceDiscoveryRegistry, (Object)e);
            }
        }
        if (this.pluginServiceDiscoveryRegistries != null) {
            for (String pluginServiceDiscoveryRegistryService : this.pluginServiceDiscoveryRegistries.getAllServices()) {
                ServiceDiscoveryRegistry pluginServiceDiscoveryRegistry = (ServiceDiscoveryRegistry)this.pluginServiceDiscoveryRegistries.getServiceForName(pluginServiceDiscoveryRegistryService);
                if (pluginServiceDiscoveryRegistry == null) continue;
                logger.info("Unregistering Plugin ServiceDiscoveryRegistry {}", (Object)pluginServiceDiscoveryRegistry);
                try {
                    pluginServiceDiscoveryRegistry.unregister();
                }
                catch (RuntimeException e) {
                    logger.warn("Failed to unregister Plugin ServiceDiscoveryRegistry {}. Exception: {}", (Object)pluginServiceDiscoveryRegistry, (Object)e);
                }
            }
        }
    }

    private Result buildHealthcheckResponse(boolean healthy, String message) {
        if (healthy) {
            return new HealthyResultBuilder().setMessage(message).createHealthyResult();
        }
        return new UnhealthyResultBuilder().setMessage(message).createUnhealthyResult();
    }
}

