/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.listeners;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.StatusViaSLF4JLoggerFactory;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAwareBase;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.google.inject.servlet.ServletModule;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.killbill.billing.lifecycle.api.BusService;
import org.killbill.billing.lifecycle.api.Lifecycle;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.platform.config.DefaultKillbillConfigSource;
import org.killbill.billing.server.config.KillbillServerConfig;
import org.killbill.billing.server.healthchecks.KillbillHealthcheck;
import org.killbill.billing.server.healthchecks.KillbillPluginsHealthcheck;
import org.killbill.billing.server.healthchecks.KillbillQueuesHealthcheck;
import org.killbill.billing.server.metrics.InstrumentedAppender;
import org.killbill.billing.server.modules.KillbillPlatformModule;
import org.killbill.bus.api.PersistentBus;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.health.api.HealthCheckRegistry;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.modules.StatsModule;
import org.killbill.commons.metrics.servlets.HealthCheckServlet;
import org.killbill.commons.metrics.servlets.InstrumentedFilter;
import org.killbill.commons.metrics.servlets.MetricsServlet;
import org.killbill.commons.skeleton.listeners.GuiceServletContextListener;
import org.killbill.commons.skeleton.modules.BaseServerModuleBuilder;
import org.killbill.commons.skeleton.modules.JMXModule;
import org.killbill.commons.utils.annotation.VisibleForTesting;
import org.killbill.notificationq.api.NotificationQueueService;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weakref.jmx.MBeanExporter;

public class KillbillPlatformGuiceListener
extends GuiceServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(KillbillPlatformGuiceListener.class);
    public static final List<String> METRICS_SERVLETS_PATHS = List.of("/1.0/healthcheck", "/1.0/metrics", "/1.0/threads");
    protected KillbillHealthcheck killbillHealthcheck;
    protected KillbillServerConfig config;
    protected KillbillConfigSource configSource;
    protected Injector injector;
    protected Lifecycle killbillLifecycle;
    protected BusService killbillBusService;
    protected EmbeddedDB mainEmbeddedDB;
    protected EmbeddedDB shiroEmbeddedDB;
    protected EmbeddedDB osgiEmbeddedDB;

    public void contextInitialized(ServletContextEvent event) {
        try {
            this.initializeConfig();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initializeGuice(event);
        this.initializeMetrics(event);
        this.registerEhcacheMBeans();
        this.startLifecycle();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.putOutOfRotation();
        super.contextDestroyed(sce);
        if (this.killbillLifecycle == null) {
            return;
        }
        this.stopLifecycle();
        this.stopEmbeddedDBs();
        this.removeJMXExports();
        this.stopLogging();
    }

    protected void initializeConfig() throws IOException, URISyntaxException {
        this.configSource = this.getConfigSource();
        ConfigurationObjectFactory configFactory = new ConfigurationObjectFactory((ConfigSource)new KillbillPlatformConfigSource(this.configSource));
        this.config = (KillbillServerConfig)configFactory.build(KillbillServerConfig.class);
    }

    protected KillbillConfigSource getConfigSource() throws IOException, URISyntaxException {
        return new DefaultKillbillConfigSource();
    }

    protected void initializeGuice(ServletContextEvent event) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((com.fasterxml.jackson.databind.Module)new JodaModule());
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.guiceModules = List.of(this.getServletModule(), new JMXModule(new Class[]{KillbillHealthcheck.class, KillbillQueuesHealthcheck.class, NotificationQueueService.class, PersistentBus.class}), new StatsModule(METRICS_SERVLETS_PATHS.get(0), METRICS_SERVLETS_PATHS.get(1), METRICS_SERVLETS_PATHS.get(2), List.of(KillbillHealthcheck.class, KillbillPluginsHealthcheck.class, KillbillQueuesHealthcheck.class)), this.getModule(event.getServletContext()));
        super.contextInitialized(event);
        this.injector = this.injector(event);
        event.getServletContext().setAttribute(Injector.class.getName(), (Object)this.injector);
        this.mainEmbeddedDB = (EmbeddedDB)this.injector.getInstance(EmbeddedDB.class);
        this.shiroEmbeddedDB = (EmbeddedDB)this.injector.getInstance(Key.get(EmbeddedDB.class, (Annotation)Names.named((String)"shiro")));
        this.osgiEmbeddedDB = (EmbeddedDB)this.injector.getInstance(Key.get(EmbeddedDB.class, (Annotation)Names.named((String)"osgi")));
        this.killbillLifecycle = (Lifecycle)this.injector.getInstance(Lifecycle.class);
        this.killbillBusService = (BusService)this.injector.getInstance(BusService.class);
        this.killbillHealthcheck = (KillbillHealthcheck)this.injector.getInstance(KillbillHealthcheck.class);
    }

    protected ServletModule getServletModule() {
        BaseServerModuleBuilder builder = new BaseServerModuleBuilder();
        return builder.build();
    }

    protected Module getModule(ServletContext servletContext) {
        return new KillbillPlatformModule(servletContext, this.config, this.configSource);
    }

    protected void initializeMetrics(ServletContextEvent event) {
        event.getServletContext().setAttribute(HealthCheckServlet.HEALTH_CHECK_REGISTRY, this.injector.getInstance(HealthCheckRegistry.class));
        MetricRegistry metricRegistry = (MetricRegistry)this.injector.getInstance(MetricRegistry.class);
        event.getServletContext().setAttribute(MetricsServlet.METRICS_REGISTRY, (Object)metricRegistry);
        event.getServletContext().setAttribute(InstrumentedFilter.REGISTRY_ATTRIBUTE, (Object)metricRegistry);
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        if ("ch.qos.logback.classic.LoggerContext".equals(factory.getClass().getName())) {
            ch.qos.logback.classic.Logger root = ((LoggerContext)factory).getLogger("ROOT");
            InstrumentedAppender metrics = new InstrumentedAppender(metricRegistry);
            metrics.setContext((Context)root.getLoggerContext());
            metrics.start();
            root.addAppender((Appender)metrics);
        }
    }

    protected void registerEhcacheMBeans() {
    }

    protected void startLifecycle() {
        this.startLifecycleStage1();
        this.killbillLifecycle.fireStartupSequencePriorEventRegistration();
        this.startLifecycleStage2();
        this.killbillLifecycle.fireStartupSequencePostEventRegistration();
        this.startLifecycleStage3();
    }

    protected void startLifecycleStage1() {
    }

    protected void startLifecycleStage2() {
    }

    protected void startLifecycleStage3() {
    }

    protected void putOutOfRotation() {
        if (this.killbillHealthcheck != null) {
            this.killbillHealthcheck.putOutOfRotation();
            if (this.config.getShutdownDelay() != null && this.config.getShutdownDelay().getMillis() > 0L) {
                logger.info("Delaying shutdown sequence for {}ms", (Object)this.config.getShutdownDelay().getMillis());
                try {
                    Thread.sleep(this.config.getShutdownDelay().getMillis());
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted while sleeping", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                logger.info("Resuming shutdown sequence");
            }
        }
    }

    protected void stopLifecycle() {
        this.stopLifecycleStage1();
        this.killbillLifecycle.fireShutdownSequencePriorEventUnRegistration();
        this.stopLifecycleStage2();
        this.killbillLifecycle.fireShutdownSequencePostEventUnRegistration();
        this.stopLifecycleStage3();
    }

    protected void stopLifecycleStage1() {
    }

    protected void stopLifecycleStage2() {
    }

    protected void stopLifecycleStage3() {
    }

    protected void stopEmbeddedDBs() {
        this.stopEmbeddedDB(this.osgiEmbeddedDB);
        this.stopEmbeddedDB(this.shiroEmbeddedDB);
        this.stopEmbeddedDB(this.mainEmbeddedDB);
    }

    protected void stopEmbeddedDB(EmbeddedDB embeddedDB) {
        if (embeddedDB != null) {
            try {
                embeddedDB.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void removeJMXExports() {
        MBeanExporter mBeanExporter = (MBeanExporter)this.injector.getInstance(MBeanExporter.class);
        if (mBeanExporter != null) {
            mBeanExporter.unexportAllAndReportMissing();
        }
    }

    protected void stopLogging() {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        if (iLoggerFactory instanceof LoggerContext) {
            LoggerContext loggerContext = (LoggerContext)iLoggerFactory;
            ContextAwareBase contextAwareBase = new ContextAwareBase();
            contextAwareBase.setContext((Context)loggerContext);
            StatusViaSLF4JLoggerFactory.addInfo((String)("About to stop " + loggerContext.getClass().getCanonicalName() + " [" + loggerContext.getName() + "]"), (Object)((Object)this));
            loggerContext.stop();
        }
    }

    @VisibleForTesting
    public Injector getInstantiatedInjector() {
        return this.injector;
    }

    private static final class KillbillPlatformConfigSource
    implements ConfigSource {
        private final KillbillConfigSource configSource;

        private KillbillPlatformConfigSource(KillbillConfigSource configSource) {
            this.configSource = configSource;
        }

        public String getString(String propertyName) {
            return this.configSource.getString(propertyName);
        }
    }
}

