/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.metrics;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.killbill.commons.metrics.api.Meter;
import org.killbill.commons.metrics.api.MetricRegistry;

public class InstrumentedAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final MetricRegistry registry;
    private Meter all;
    private Meter trace;
    private Meter debug;
    private Meter info;
    private Meter warn;
    private Meter error;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public InstrumentedAppender(MetricRegistry registry) {
        this.registry = registry;
        this.setName(Appender.class.getName());
    }

    public void start() {
        this.all = this.registry.meter(this.getName() + ".all");
        this.trace = this.registry.meter(this.getName() + ".trace");
        this.debug = this.registry.meter(this.getName() + ".debug");
        this.info = this.registry.meter(this.getName() + ".info");
        this.warn = this.registry.meter(this.getName() + ".warn");
        this.error = this.registry.meter(this.getName() + ".error");
        super.start();
    }

    protected void append(ILoggingEvent event) {
        this.all.mark(1L);
        switch (event.getLevel().toInt()) {
            case 5000: {
                this.trace.mark(1L);
                break;
            }
            case 10000: {
                this.debug.mark(1L);
                break;
            }
            case 20000: {
                this.info.mark(1L);
                break;
            }
            case 30000: {
                this.warn.mark(1L);
                break;
            }
            case 40000: {
                this.error.mark(1L);
                break;
            }
        }
    }
}

