/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.healthchecks;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.osgi.api.Healthcheck;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.killbill.commons.health.api.HealthCheck;
import org.killbill.commons.health.api.Result;
import org.killbill.commons.health.impl.HealthyResultBuilder;
import org.killbill.commons.health.impl.UnhealthyResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KillbillPluginsHealthcheck
implements HealthCheck {
    private static final Logger logger = LoggerFactory.getLogger(KillbillPluginsHealthcheck.class);
    private OSGIServiceRegistration<Healthcheck> pluginHealthchecks = null;

    @Inject
    public void setPluginHealthchecks(@Nullable OSGIServiceRegistration<Healthcheck> pluginHealthchecks) {
        this.pluginHealthchecks = pluginHealthchecks;
    }

    public Result check() {
        HashMap<String, Map> details = new HashMap<String, Map>();
        boolean isHealthy = true;
        if (this.pluginHealthchecks != null) {
            for (String pluginHealthcheckService : this.pluginHealthchecks.getAllServices()) {
                Healthcheck pluginHealthcheck = (Healthcheck)this.pluginHealthchecks.getServiceForName(pluginHealthcheckService);
                if (pluginHealthcheck == null) continue;
                Healthcheck.HealthStatus pluginStatus = pluginHealthcheck.getHealthStatus(null, null);
                details.put(pluginHealthcheckService, pluginStatus.getDetails());
                isHealthy = isHealthy && pluginStatus.isHealthy();
            }
        }
        if (isHealthy) {
            return new HealthyResultBuilder().setDetails(details).createHealthyResult();
        }
        return new UnhealthyResultBuilder().setDetails(details).createUnhealthyResult();
    }
}

