/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.metrics;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.killbill.billing.osgi.api.OSGISingleServiceRegistration;
import org.killbill.commons.metrics.api.Counter;
import org.killbill.commons.metrics.api.Gauge;
import org.killbill.commons.metrics.api.Histogram;
import org.killbill.commons.metrics.api.Meter;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.api.Snapshot;
import org.killbill.commons.metrics.api.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillbillPluginsMetricRegistry
implements MetricRegistry {
    private static final Logger logger = LoggerFactory.getLogger(KillbillPluginsMetricRegistry.class);
    private final OSGISingleServiceRegistration<MetricRegistry> pluginMetricRegistry;

    public KillbillPluginsMetricRegistry(OSGISingleServiceRegistration<MetricRegistry> pluginMetricRegistry) {
        this.pluginMetricRegistry = pluginMetricRegistry;
    }

    public Counter counter(final String name) {
        return new Counter(){

            public void inc(long n) {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                if (service != null) {
                    service.counter(name).inc(n);
                }
            }

            public long getCount() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.counter(name).getCount() : 0L;
            }
        };
    }

    public <T> Gauge<T> gauge(final String name, final Gauge<T> gauge) {
        this.pluginMetricRegistry.addRegistrationListener(new Runnable(){

            @Override
            public void run() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                if (service != null) {
                    service.gauge(name, gauge);
                }
            }
        });
        return new Gauge<T>(){

            public T getValue() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.gauge(name, gauge).getValue() : null;
            }
        };
    }

    public Histogram histogram(final String name) {
        return new Histogram(){

            public void update(long value) {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                if (service != null) {
                    service.histogram(name).update(value);
                }
            }

            public long getCount() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.histogram(name).getCount() : 0L;
            }

            public Snapshot getSnapshot() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.histogram(name).getSnapshot() : null;
            }
        };
    }

    public Meter meter(final String name) {
        return new Meter(){

            public void mark(long n) {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                if (service != null) {
                    service.meter(name).mark(n);
                }
            }

            public double getFifteenMinuteRate() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.meter(name).getFifteenMinuteRate() : 0.0;
            }

            public double getFiveMinuteRate() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.meter(name).getFiveMinuteRate() : 0.0;
            }

            public double getMeanRate() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.meter(name).getMeanRate() : 0.0;
            }

            public double getOneMinuteRate() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.meter(name).getOneMinuteRate() : 0.0;
            }

            public long getCount() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.meter(name).getCount() : 0L;
            }
        };
    }

    public Timer timer(final String name) {
        return new Timer(){

            public long getCount() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.timer(name).getCount() : 0L;
            }

            public void update(long duration, TimeUnit unit) {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                if (service != null) {
                    service.timer(name).update(duration, unit);
                }
            }

            public double getFifteenMinuteRate() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.timer(name).getFifteenMinuteRate() : 0.0;
            }

            public double getFiveMinuteRate() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.timer(name).getFiveMinuteRate() : 0.0;
            }

            public double getMeanRate() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.timer(name).getMeanRate() : 0.0;
            }

            public double getOneMinuteRate() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.timer(name).getOneMinuteRate() : 0.0;
            }

            public Snapshot getSnapshot() {
                MetricRegistry service = (MetricRegistry)KillbillPluginsMetricRegistry.this.pluginMetricRegistry.getService();
                return service != null ? service.timer(name).getSnapshot() : null;
            }
        };
    }

    public boolean remove(String name) {
        MetricRegistry service = (MetricRegistry)this.pluginMetricRegistry.getService();
        return service != null && service.remove(name);
    }

    public Map<String, ?> getMetrics() {
        MetricRegistry service = (MetricRegistry)this.pluginMetricRegistry.getService();
        return service != null ? service.getMetrics() : Collections.emptyMap();
    }

    public Map<String, Counter> getCounters() {
        MetricRegistry service = (MetricRegistry)this.pluginMetricRegistry.getService();
        return service != null ? service.getCounters() : Collections.emptyMap();
    }

    public Map<String, Histogram> getHistograms() {
        MetricRegistry service = (MetricRegistry)this.pluginMetricRegistry.getService();
        return service != null ? service.getHistograms() : Collections.emptyMap();
    }

    public Map<String, Gauge<?>> getGauges() {
        MetricRegistry service = (MetricRegistry)this.pluginMetricRegistry.getService();
        return service != null ? service.getGauges() : Collections.emptyMap();
    }

    public Map<String, Meter> getMeters() {
        MetricRegistry service = (MetricRegistry)this.pluginMetricRegistry.getService();
        return service != null ? service.getMeters() : Collections.emptyMap();
    }

    public Map<String, Timer> getTimers() {
        MetricRegistry service = (MetricRegistry)this.pluginMetricRegistry.getService();
        return service != null ? service.getTimers() : Collections.emptyMap();
    }
}

