/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.modules;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.killbill.billing.lifecycle.glue.BusModule;
import org.killbill.billing.lifecycle.glue.LifecycleModule;
import org.killbill.billing.osgi.MetricRegistryServiceRegistration;
import org.killbill.billing.osgi.ServiceRegistryServiceRegistration;
import org.killbill.billing.osgi.api.OSGIConfigProperties;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.killbill.billing.osgi.api.OSGISingleServiceRegistration;
import org.killbill.billing.osgi.api.ServiceDiscoveryRegistry;
import org.killbill.billing.osgi.glue.DefaultOSGIModule;
import org.killbill.billing.osgi.glue.OSGIDataSourceConfig;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.platform.config.DefaultKillbillConfigSource;
import org.killbill.billing.platform.glue.KillBillPlatformModuleBase;
import org.killbill.billing.platform.glue.NotificationQueueModule;
import org.killbill.billing.platform.glue.ReferenceableDataSourceSpyProvider;
import org.killbill.billing.platform.jndi.JNDIManager;
import org.killbill.billing.server.config.KillbillServerConfig;
import org.killbill.billing.server.metrics.KillbillPluginsMetricRegistry;
import org.killbill.billing.server.modules.DistributedClockProvider;
import org.killbill.billing.server.modules.EmbeddedDBProvider;
import org.killbill.billing.server.modules.MainRoDaoConfig;
import org.killbill.billing.server.modules.RODBIProvider;
import org.killbill.clock.Clock;
import org.killbill.clock.ClockMock;
import org.killbill.clock.DefaultClock;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.jdbi.guice.DBIProvider;
import org.killbill.commons.jdbi.guice.DaoConfig;
import org.killbill.commons.jdbi.metrics.KillBillTimingCollector;
import org.killbill.commons.jdbi.notification.DatabaseTransactionNotificationApi;
import org.killbill.commons.jdbi.transaction.NotificationTransactionHandler;
import org.killbill.commons.jdbi.transaction.RestartTransactionRunner;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.guice.MetricsInstrumentationModule;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.tweak.TransactionHandler;

public class KillbillPlatformModule
extends KillBillPlatformModuleBase {
    protected final ServletContext servletContext;
    protected final KillbillServerConfig serverConfig;
    protected DaoConfig daoConfig;
    protected MainRoDaoConfig mainRoDataSourceConfig;
    protected EmbeddedDB mainEmbeddedDB;
    protected EmbeddedDB mainRoEmbeddedDB;
    protected EmbeddedDB shiroEmbeddedDB;

    public KillbillPlatformModule(ServletContext servletContext, KillbillServerConfig serverConfig, KillbillConfigSource configSource) {
        super(configSource);
        this.servletContext = servletContext;
        this.serverConfig = serverConfig;
    }

    protected void configure() {
        this.configureJackson();
        this.configureClock();
        this.configureDao();
        this.configureConfig();
        this.configureEmbeddedDBs();
        this.configureLifecycle();
        this.configureBuses();
        this.configureNotificationQ();
        this.configureOSGI();
        this.configureJNDI();
        this.configureMetrics();
    }

    protected void configureJackson() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((com.fasterxml.jackson.databind.Module)new JodaModule());
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.bind(ObjectMapper.class).toInstance((Object)objectMapper);
    }

    protected void configureClock() {
        if (this.serverConfig.isTestModeEnabled()) {
            if (this.serverConfig.isRedisClockEnabled()) {
                this.bind(Clock.class).toProvider(DistributedClockProvider.class).asEagerSingleton();
            } else {
                this.bind(Clock.class).to(ClockMock.class).asEagerSingleton();
            }
        } else {
            this.bind(Clock.class).to(DefaultClock.class).asEagerSingleton();
        }
    }

    protected void configureDao() {
        this.daoConfig = (DaoConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(DaoConfig.class);
        this.bind(DaoConfig.class).toInstance((Object)this.daoConfig);
        this.mainRoDataSourceConfig = (MainRoDaoConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(MainRoDaoConfig.class);
        this.bind(MainRoDaoConfig.class).toInstance((Object)this.mainRoDataSourceConfig);
        DatabaseTransactionNotificationApi databaseTransactionNotificationApi = new DatabaseTransactionNotificationApi();
        this.bind(DatabaseTransactionNotificationApi.class).toInstance((Object)databaseTransactionNotificationApi);
        NotificationTransactionHandler notificationTransactionHandler = new NotificationTransactionHandler(databaseTransactionNotificationApi);
        RestartTransactionRunner ourSuperTunedTransactionHandler = new RestartTransactionRunner((TransactionHandler)notificationTransactionHandler);
        this.bind(TransactionHandler.class).toInstance((Object)ourSuperTunedTransactionHandler);
        this.bind(IDBI.class).toProvider(DBIProvider.class).asEagerSingleton();
        this.bind(IDBI.class).annotatedWith((Annotation)Names.named((String)"Queue")).toProvider(DBIProvider.class).asEagerSingleton();
        this.bind(IDBI.class).annotatedWith((Annotation)Names.named((String)"main-ro")).toProvider(RODBIProvider.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    protected DataSource provideDataSourceInAComplicatedWayBecauseOf627(Injector injector) {
        return this.provideDataSourceInAComplicatedWayBecauseOf627(injector, this.daoConfig, this.mainEmbeddedDB, "main");
    }

    @Provides
    @Named(value="main-ro")
    @Singleton
    protected DataSource provideMainRoDataSourceInAComplicatedWayBecauseOf627(Injector injector) {
        if (this.mainRoDataSourceConfig.isEnabled()) {
            return this.provideDataSourceInAComplicatedWayBecauseOf627(injector, this.mainRoDataSourceConfig, this.mainRoEmbeddedDB, "main-ro");
        }
        return (DataSource)injector.getInstance(DataSource.class);
    }

    @Provides
    @Named(value="shiro")
    @Singleton
    protected DataSource provideShiroDataSourceInAComplicatedWayBecauseOf627(Injector injector) {
        return this.provideDataSourceInAComplicatedWayBecauseOf627(injector, this.daoConfig, this.shiroEmbeddedDB, "shiro");
    }

    protected DataSource provideDataSourceInAComplicatedWayBecauseOf627(Injector injector, DaoConfig daoConfig, EmbeddedDB embeddedDB, String dataSourceId) {
        ReferenceableDataSourceSpyProvider dataSourceSpyProvider = new ReferenceableDataSourceSpyProvider(daoConfig, embeddedDB, dataSourceId);
        injector.injectMembers((Object)dataSourceSpyProvider);
        return (DataSource)dataSourceSpyProvider.get();
    }

    @Provides
    @Singleton
    protected TimingCollector provideTimingCollector(MetricRegistry metricRegistry) {
        return new KillBillTimingCollector(metricRegistry);
    }

    protected void configureConfig() {
        this.bind(ConfigSource.class).toInstance((Object)this.skifeConfigSource);
        this.bind(KillbillServerConfig.class).toInstance((Object)this.serverConfig);
    }

    protected void configureEmbeddedDBs() {
        this.mainEmbeddedDB = new EmbeddedDBProvider(this.daoConfig).get();
        this.bind(EmbeddedDB.class).toInstance((Object)this.mainEmbeddedDB);
        this.shiroEmbeddedDB = new EmbeddedDBProvider(this.daoConfig).get();
        this.bind(EmbeddedDB.class).annotatedWith((Annotation)Names.named((String)"shiro")).toInstance((Object)this.shiroEmbeddedDB);
        this.mainRoEmbeddedDB = this.mainRoDataSourceConfig.isEnabled() ? new EmbeddedDBProvider(this.mainRoDataSourceConfig).get() : this.mainEmbeddedDB;
        this.bind(EmbeddedDB.class).annotatedWith((Annotation)Names.named((String)"main-ro")).toInstance((Object)this.mainRoEmbeddedDB);
    }

    protected void configureLifecycle() {
        this.install((Module)new LifecycleModule());
    }

    protected void configureBuses() {
        this.install((Module)new BusModule(BusModule.BusType.PERSISTENT, false, this.configSource));
        this.install((Module)new BusModule(BusModule.BusType.PERSISTENT, true, this.configSource));
    }

    protected void configureNotificationQ() {
        this.install((Module)new NotificationQueueModule(this.configSource));
    }

    protected void configureOSGI() {
        OSGIDataSourceConfig osgiDataSourceConfig = (OSGIDataSourceConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(OSGIDataSourceConfig.class);
        EmbeddedDB osgiEmbeddedDB = new EmbeddedDBProvider((DaoConfig)osgiDataSourceConfig).get();
        this.bind(EmbeddedDB.class).annotatedWith((Annotation)Names.named((String)"osgi")).toInstance((Object)osgiEmbeddedDB);
        this.install((Module)new DefaultOSGIModule(this.configSource, (OSGIConfigProperties)((DefaultKillbillConfigSource)this.configSource), osgiDataSourceConfig, osgiEmbeddedDB));
    }

    protected void configureJNDI() {
        this.bind(JNDIManager.class).asEagerSingleton();
    }

    protected void configureMetrics() {
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<ServiceDiscoveryRegistry>>(){}).to(ServiceRegistryServiceRegistration.class).asEagerSingleton();
        MetricRegistryServiceRegistration metricRegistryServiceRegistration = new MetricRegistryServiceRegistration();
        this.bind((TypeLiteral)new TypeLiteral<OSGISingleServiceRegistration<MetricRegistry>>(){}).toInstance((Object)metricRegistryServiceRegistration);
        KillbillPluginsMetricRegistry metricRegistry = new KillbillPluginsMetricRegistry((OSGISingleServiceRegistration<MetricRegistry>)metricRegistryServiceRegistration);
        this.bind(MetricRegistry.class).toInstance((Object)metricRegistry);
        this.install((Module)MetricsInstrumentationModule.builder().withMetricRegistry((MetricRegistry)metricRegistry).build());
    }
}

