/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.server.updatechecker;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.killbill.commons.utils.Strings;
import org.killbill.commons.utils.io.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductInfo {
    private static final Logger log = LoggerFactory.getLogger(ProductInfo.class);
    private static final String KILLBILL_SERVER_VERSION_RESOURCE = "/org/killbill/billing/server/version.properties";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String PRODUCT_NAME = "product-name";
    private static final String VERSION = "version";
    private static final String BUILT_BY = "built-by";
    private static final String BUILD_JDK = "build-jdk";
    private static final String BUILD_TIME = "build-time";
    private static final String ENTERPRISE = "enterprise";
    private final Properties props = new Properties();

    public ProductInfo() {
        try {
            this.parseProductInfo(KILLBILL_SERVER_VERSION_RESOURCE);
        }
        catch (IOException e) {
            log.debug("Unable to detect current product info", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseProductInfo(String resource) throws IOException {
        URL resourceURL = Resources.getResource((String)resource);
        try (InputStream inStream = resourceURL.openStream();){
            this.props.load(inStream);
        }
    }

    public String getName() {
        return this.getProperty(PRODUCT_NAME);
    }

    public String getVersion() {
        return this.getProperty(VERSION);
    }

    public String getBuiltBy() {
        return this.getProperty(BUILT_BY);
    }

    public String getBuildJdk() {
        return this.getProperty(BUILD_JDK);
    }

    public String getBuildTime() {
        return this.getProperty(BUILD_TIME);
    }

    public boolean isEnterprise() {
        return Boolean.parseBoolean(this.props.getProperty(ENTERPRISE));
    }

    private String getProperty(String key) {
        return this.getSanitizedString(this.props.getProperty(key, UNKNOWN));
    }

    private String getSanitizedString(String string) {
        return Strings.isNullOrEmpty((String)string) ? UNKNOWN : string.trim();
    }

    public String toString() {
        String fullProductName = String.format("%s (%s)", this.getName(), this.isEnterprise() ? ENTERPRISE : "community");
        return String.format("%s version %s was built on %s, with jdk %s by %s", fullProductName, this.getVersion(), this.getBuildTime(), this.getBuildJdk(), this.getBuiltBy());
    }
}

