/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.test.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.killbill.billing.platform.config.DefaultKillbillConfigSource;
import org.killbill.billing.platform.test.PlatformDBTestingHelper;
import org.killbill.commons.embeddeddb.EmbeddedDB;

public class TestKillbillConfigSource
extends DefaultKillbillConfigSource {
    private final String jdbcConnectionString;
    private final String jdbcUsername;
    private final String jdbcPassword;
    private final Map<String, String> extraDefaults;

    public TestKillbillConfigSource(@Nullable Class<? extends PlatformDBTestingHelper> dbTestingHelperKlass) throws URISyntaxException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, IOException {
        this(null, dbTestingHelperKlass);
    }

    public TestKillbillConfigSource(@Nullable String file, @Nullable Class<? extends PlatformDBTestingHelper> dbTestingHelperKlass) throws IOException, URISyntaxException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        this(file, dbTestingHelperKlass, (Map<String, String>)ImmutableMap.of());
    }

    public TestKillbillConfigSource(@Nullable String file, @Nullable Class<? extends PlatformDBTestingHelper> dbTestingHelperKlass, Map<String, String> extraDefaults) throws IOException, URISyntaxException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        super(file);
        this.populateDefaultProperties();
        if (dbTestingHelperKlass != null) {
            PlatformDBTestingHelper dbTestingHelper = (PlatformDBTestingHelper)dbTestingHelperKlass.getDeclaredMethod("get", new Class[0]).invoke(null, new Object[0]);
            EmbeddedDB instance = dbTestingHelper.getInstance();
            this.jdbcConnectionString = instance.getJdbcConnectionString();
            this.jdbcUsername = instance.getUsername();
            this.jdbcPassword = instance.getPassword();
        } else {
            this.jdbcConnectionString = null;
            this.jdbcUsername = null;
            this.jdbcPassword = null;
        }
        this.extraDefaults = extraDefaults;
        this.populateDefaultProperties();
    }

    protected Properties getDefaultProperties() {
        Properties properties = super.getDefaultProperties();
        if (this.jdbcConnectionString != null) {
            properties.put("org.killbill.dao.url", this.jdbcConnectionString);
            properties.put("org.killbill.billing.osgi.dao.url", this.jdbcConnectionString);
        }
        if (this.jdbcUsername != null) {
            properties.put("org.killbill.dao.user", this.jdbcUsername);
            properties.put("org.killbill.billing.osgi.dao.user", this.jdbcUsername);
        }
        if (this.jdbcPassword != null) {
            properties.put("org.killbill.dao.password", this.jdbcPassword);
            properties.put("org.killbill.billing.osgi.dao.password", this.jdbcPassword);
        }
        properties.put("org.killbill.notificationq.main.sleep", "100");
        properties.put("org.killbill.notificationq.main.nbThreads", "1");
        properties.put("org.killbill.notificationq.main.claimed", "1");
        properties.put("org.killbill.notificationq.main.queue.mode", "STICKY_POLLING");
        properties.put("org.killbill.persistent.bus.main.sleep", "100");
        properties.put("org.killbill.persistent.bus.main.nbThreads", "1");
        properties.put("org.killbill.persistent.bus.main.claimed", "1");
        properties.put("org.killbill.persistent.bus.main.queue.mode", "STICKY_POLLING");
        properties.put("org.killbill.persistent.bus.external.sleep", "100");
        properties.put("org.killbill.persistent.bus.external.nbThreads", "1");
        properties.put("org.killbill.persistent.bus.external.claimed", "1");
        properties.put("org.killbill.persistent.bus.external.queue.mode", "STICKY_POLLING");
        properties.put("org.killbill.osgi.root.dir", Files.createTempDir().getAbsolutePath());
        properties.put("org.killbill.osgi.bundle.install.dir", Files.createTempDir().getAbsolutePath());
        if (this.extraDefaults != null) {
            for (Map.Entry<String, String> entry : this.extraDefaults.entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        return properties;
    }

    protected Properties getDefaultSystemProperties() {
        Properties properties = super.getDefaultSystemProperties();
        properties.put("net.sf.ehcache.skipUpdateCheck", "true");
        properties.put("org.slf4j.simpleLogger.showDateTime", "true");
        return properties;
    }
}

