/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.test.glue;

import com.google.inject.Module;
import java.util.Set;
import javax.annotation.Nullable;
import org.killbill.billing.lifecycle.DefaultLifecycle;
import org.killbill.billing.lifecycle.api.Lifecycle;
import org.killbill.billing.lifecycle.config.LifecycleConfig;
import org.killbill.billing.lifecycle.glue.BusModule;
import org.killbill.billing.osgi.api.OSGIConfigProperties;
import org.killbill.billing.osgi.api.PluginInfo;
import org.killbill.billing.osgi.glue.DefaultOSGIModule;
import org.killbill.billing.osgi.glue.OSGIDataSourceConfig;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.platform.glue.KillBillPlatformModuleBase;
import org.killbill.billing.platform.glue.NotificationQueueModule;
import org.killbill.billing.platform.jndi.JNDIManager;
import org.killbill.billing.platform.test.PlatformDBTestingHelper;
import org.killbill.billing.util.nodes.KillbillNodesApi;
import org.killbill.billing.util.nodes.NodeCommand;
import org.killbill.billing.util.nodes.NodeInfo;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.skife.config.ConfigurationObjectFactory;

public abstract class TestPlatformModule
extends KillBillPlatformModuleBase {
    private final boolean withOSGI;
    private final OSGIConfigProperties osgiConfigProperties;
    private final Set<? extends KillbillService> services;

    protected TestPlatformModule(KillbillConfigSource configSource, boolean withOSGI, @Nullable OSGIConfigProperties osgiConfigProperties, @Nullable Set<? extends KillbillService> services) {
        super(configSource);
        this.withOSGI = withOSGI;
        this.osgiConfigProperties = osgiConfigProperties;
        this.services = services;
    }

    protected void configure() {
        this.configureEmbeddedDB();
        this.configureLifecycle();
        this.configureNotificationQ();
        this.configureBus();
        if (this.withOSGI) {
            this.configureExternalBus();
            this.configureOSGI();
        }
        this.configureJNDI();
        this.configureKillbillNodesApi();
    }

    protected abstract void configureEmbeddedDB();

    protected void configureLifecycle() {
        if (this.services != null) {
            this.bind(Lifecycle.class).toInstance((Object)new DefaultLifecycle(this.services));
        } else {
            this.bind(Lifecycle.class).to(DefaultLifecycle.class).asEagerSingleton();
        }
        LifecycleConfig lifecycleConfig = (LifecycleConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(LifecycleConfig.class);
        this.bind(LifecycleConfig.class).toInstance((Object)lifecycleConfig);
    }

    protected void configureBus() {
        this.install((Module)new BusModule(BusModule.BusType.PERSISTENT, false, this.configSource));
    }

    protected void configureExternalBus() {
        this.install((Module)new BusModule(BusModule.BusType.PERSISTENT, true, this.configSource));
    }

    protected void configureNotificationQ() {
        this.install((Module)new NotificationQueueModule(this.configSource));
    }

    protected void configureOSGI() {
        OSGIDataSourceConfig osgiDataSourceConfig = (OSGIDataSourceConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(OSGIDataSourceConfig.class);
        EmbeddedDB embeddedDB = PlatformDBTestingHelper.get().getInstance();
        this.install((Module)new DefaultOSGIModule(this.configSource, this.osgiConfigProperties, osgiDataSourceConfig, embeddedDB));
    }

    protected void configureJNDI() {
        this.bind(JNDIManager.class).asEagerSingleton();
    }

    protected void configureKillbillNodesApi() {
        KillbillNodesApi dummyInstance = new KillbillNodesApi(){

            public Iterable<NodeInfo> getNodesInfo() {
                throw new UnsupportedOperationException("Not implemented");
            }

            public NodeInfo getCurrentNodeInfo() {
                return null;
            }

            public void triggerNodeCommand(NodeCommand nodeCommandfinal, boolean localNodeOnly) {
                throw new UnsupportedOperationException("Not implemented");
            }

            public void notifyPluginChanged(PluginInfo pluginInfo, Iterable<PluginInfo> latestPlugins) {
                throw new UnsupportedOperationException("Not implemented");
            }
        };
        this.bind(KillbillNodesApi.class).toInstance((Object)dummyInstance);
    }
}

