/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Enumeration;
import javax.sql.DataSource;
import org.killbill.billing.platform.test.PlatformDBTestingHelper;
import org.killbill.billing.util.glue.IDBISetup;
import org.killbill.billing.util.io.IOUtils;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.jdbi.guice.DBIProvider;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTestingHelper
extends PlatformDBTestingHelper {
    private static DBTestingHelper dbTestingHelper = null;
    private DBI dbi;

    public static synchronized DBTestingHelper get() {
        if (dbTestingHelper == null) {
            dbTestingHelper = new DBTestingHelper();
        }
        return dbTestingHelper;
    }

    private DBTestingHelper() {
    }

    public synchronized IDBI getDBI() {
        if (this.dbi == null) {
            RetryableDataSource retryableDataSource = new RetryableDataSource(this.getDataSource());
            this.dbi = (DBI)new DBIProvider(null, (DataSource)retryableDataSource, null).get();
            for (ResultSetMapperFactory resultSetMapperFactory : IDBISetup.mapperFactoriesToRegister()) {
                this.dbi.registerMapper(resultSetMapperFactory);
            }
            for (ResultSetMapper resultSetMapper : IDBISetup.mappersToRegister()) {
                this.dbi.registerMapper(resultSetMapper);
            }
        }
        return this.dbi;
    }

    protected synchronized void executePostStartupScripts() throws IOException {
        EmbeddedDB instance = this.getInstance();
        String databaseSpecificDDL = "org/killbill/billing/util/ddl-" + instance.getDBEngine().name().toLowerCase() + ".sql";
        this.installDDLSilently(databaseSpecificDDL);
        instance.executeScript("drop table if exists accounts;CREATE TABLE accounts (\n    record_id serial unique,\n    id varchar(36) NOT NULL,\n    external_key varchar(255) NULL,\n    email varchar(128) DEFAULT NULL,\n    name varchar(100) DEFAULT NULL,\n    first_name_length int DEFAULT NULL,\n    currency varchar(3) DEFAULT NULL,\n    billing_cycle_day_local int DEFAULT NULL,\n    parent_account_id varchar(36) DEFAULT NULL,\n    is_payment_delegated_to_parent boolean DEFAULT FALSE,\n    payment_method_id varchar(36) DEFAULT NULL,\n    time_zone varchar(50) NOT NULL,\n    locale varchar(5) DEFAULT NULL,\n    address1 varchar(100) DEFAULT NULL,\n    address2 varchar(100) DEFAULT NULL,\n    company_name varchar(50) DEFAULT NULL,\n    city varchar(50) DEFAULT NULL,\n    state_or_province varchar(50) DEFAULT NULL,\n    country varchar(50) DEFAULT NULL,\n    postal_code varchar(16) DEFAULT NULL,\n    phone varchar(25) DEFAULT NULL,\n    notes varchar(4096) DEFAULT NULL,\n    migrated boolean default false,\n    is_notified_for_invoices boolean NOT NULL,\n    created_date datetime NOT NULL,\n    created_by varchar(50) NOT NULL,\n    updated_date datetime DEFAULT NULL,\n    updated_by varchar(50) DEFAULT NULL,\n    tenant_record_id bigint /*! unsigned */ not null default 0,\n    PRIMARY KEY(record_id)\n);");
        instance.executeScript("DROP TABLE IF EXISTS tenants;\nCREATE TABLE tenants (\n    record_id serial unique,\n    id varchar(36) NOT NULL,\n    external_key varchar(255) NULL,\n    api_key varchar(128) NULL,\n    api_secret varchar(128) NULL,\n    api_salt varchar(128) NULL,\n    created_date datetime NOT NULL,\n    created_by varchar(50) NOT NULL,\n    updated_date datetime DEFAULT NULL,\n    updated_by varchar(50) DEFAULT NULL,\n    PRIMARY KEY(record_id)\n);");
        instance.executeScript("DROP TABLE IF EXISTS bundles;\nCREATE TABLE bundles (\n    record_id serial unique,\n    id varchar(36) NOT NULL,\n    external_key varchar(255) NOT NULL,\n    account_id varchar(36) NOT NULL,\n    last_sys_update_date datetime,\n    original_created_date datetime NOT NULL,\n    created_by varchar(50) NOT NULL,\n    created_date datetime NOT NULL,\n    updated_by varchar(50) NOT NULL,\n    updated_date datetime NOT NULL,\n    account_record_id bigint /*! unsigned */ not null,\n    tenant_record_id bigint /*! unsigned */ not null default 0,\n    PRIMARY KEY(record_id)\n);");
        instance.executeScript("DROP TABLE IF EXISTS subscriptions;\nCREATE TABLE subscriptions (\n    record_id serial unique,\n    id varchar(36) NOT NULL,\n    bundle_id varchar(36) NOT NULL,\n    category varchar(32) NOT NULL,\n    start_date datetime NOT NULL,\n    bundle_start_date datetime NOT NULL,\n    charged_through_date datetime DEFAULT NULL,\n    migrated bool NOT NULL default FALSE,\n    created_by varchar(50) NOT NULL,\n    created_date datetime NOT NULL,\n    updated_by varchar(50) NOT NULL,\n    updated_date datetime NOT NULL,\n    account_record_id bigint /*! unsigned */ not null,\n    tenant_record_id bigint /*! unsigned */ not null default 0,\n    PRIMARY KEY(record_id)\n);");
        instance.executeScript("DROP TABLE IF EXISTS payments;\nCREATE TABLE payments (\n    record_id serial unique,\n    id varchar(36) NOT NULL,\n    account_id varchar(36) NOT NULL,\n    payment_method_id varchar(36) NOT NULL,\n    external_key varchar(255) NOT NULL,\n    state_name varchar(64) DEFAULT NULL,\n    last_success_state_name varchar(64) DEFAULT NULL,\n    created_by varchar(50) NOT NULL,\n    created_date datetime NOT NULL,\n    updated_by varchar(50) NOT NULL,\n    updated_date datetime NOT NULL,\n    account_record_id bigint /*! unsigned */ not null,\n    tenant_record_id bigint /*! unsigned */ not null default 0,\n    PRIMARY KEY (record_id)\n);");
        for (String pack : new String[]{"catalog", "account", "analytics", "beatrix", "subscription", "util", "payment", "invoice", "entitlement", "usage", "meter", "tenant"}) {
            for (String ddlFile : new String[]{"ddl.sql", "ddl_test.sql"}) {
                String resourceName = "org/killbill/billing/" + pack + "/" + ddlFile;
                this.installDDLSilently(resourceName);
            }
        }
    }

    private void installDDLSilently(String resourceName) throws IOException {
        ClassLoader classLoader = (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)DBTestingHelper.class.getClassLoader());
        Enumeration<URL> resources = classLoader.getResources(resourceName);
        while (resources.hasMoreElements()) {
            URL inputStream = resources.nextElement();
            try {
                String ddl = IOUtils.toString((InputStream)inputStream.openStream());
                this.getInstance().executeScript(ddl);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RetryableDataSource
    implements DataSource {
        private static final Logger logger = LoggerFactory.getLogger(RetryableDataSource.class);
        private final DataSource delegate;

        private RetryableDataSource(DataSource delegate) {
            this.delegate = delegate;
        }

        @Override
        public Connection getConnection() throws SQLException {
            try {
                return this.delegate.getConnection();
            }
            catch (SQLNonTransientConnectionException e) {
                logger.warn("Unable to retrieve connection, attempting to retry", (Throwable)e);
                return this.delegate.getConnection();
            }
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            try {
                return this.delegate.getConnection(username, password);
            }
            catch (SQLNonTransientConnectionException e) {
                logger.warn("Unable to retrieve connection, attempting to retry", (Throwable)e);
                return this.delegate.getConnection(username, password);
            }
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.delegate.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.delegate.isWrapperFor(iface);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.delegate.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.delegate.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.delegate.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.delegate.getLoginTimeout();
        }

        @Override
        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("javax.sql.DataSource.getParentLogger() is not currently supported by " + this.getClass().getName());
        }
    }
}

