/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.UUID;
import javax.inject.Inject;
import org.killbill.billing.DBTestingHelper;
import org.killbill.billing.KillbillTestSuite;
import org.killbill.billing.api.FlakyInvokedMethodListener;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.callcontext.MutableInternalCallContext;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.platform.test.config.TestKillbillConfigSource;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.clock.ClockMock;
import org.skife.config.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Listeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Listeners(value={FlakyInvokedMethodListener.class})
public class GuicyKillbillTestSuite
implements IHookable {
    protected static final Logger log = LoggerFactory.getLogger((String)KillbillTestSuite.class.getSimpleName());
    private boolean hasFailed = false;
    @Inject
    protected InternalCallContextFactory internalCallContextFactory;
    @Inject
    protected MutableInternalCallContext internalCallContext;
    @Inject
    protected CallContext callContext;
    @Inject
    protected ClockMock clock;
    private static final ClockMock theStaticClock = new ClockMock();
    protected final KillbillConfigSource configSource = this.getConfigSource();
    protected final ConfigSource skifeConfigSource = new ConfigSource(){

        public String getString(String propertyName) {
            return GuicyKillbillTestSuite.this.configSource.getString(propertyName);
        }
    };

    protected KillbillConfigSource getConfigSource() {
        try {
            return new TestKillbillConfigSource(DBTestingHelper.class);
        }
        catch (Exception e) {
            AssertionError assertionError = new AssertionError((Object)"Initialization error");
            ((Throwable)((Object)assertionError)).initCause(e);
            throw assertionError;
        }
    }

    protected KillbillConfigSource getConfigSource(String file) {
        return this.getConfigSource(file, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    protected KillbillConfigSource getConfigSource(String file, ImmutableMap<String, String> extraProperties) {
        try {
            return new TestKillbillConfigSource(file, DBTestingHelper.class, extraProperties);
        }
        catch (Exception e) {
            AssertionError assertionError = new AssertionError((Object)"Initialization error");
            ((Throwable)((Object)assertionError)).initCause(e);
            throw assertionError;
        }
    }

    public static ClockMock getClock() {
        return theStaticClock;
    }

    public static void refreshCallContext(UUID accountId, Clock clock, InternalCallContextFactory internalCallContextFactory, TenantContext callContext, MutableInternalCallContext internalCallContext) {
        InternalTenantContext tmp = internalCallContextFactory.createInternalTenantContext(accountId, callContext);
        internalCallContext.setAccountRecordId(tmp.getAccountRecordId());
        internalCallContext.setFixedOffsetTimeZone(tmp.getFixedOffsetTimeZone());
        internalCallContext.setReferenceTime(tmp.getReferenceTime());
        internalCallContext.setCreatedDate(clock.getUTCNow());
        internalCallContext.setUpdatedDate(clock.getUTCNow());
    }

    protected void refreshCallContext(UUID accountId) {
        GuicyKillbillTestSuite.refreshCallContext(accountId, (Clock)this.clock, this.internalCallContextFactory, (TenantContext)this.callContext, this.internalCallContext);
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethodAlwaysRun(Method method) throws Exception {
        log.info("***************************************************************************************************");
        log.info("*** Starting test {}:{}", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
        log.info("***************************************************************************************************");
        if (this.internalCallContext != null) {
            this.internalCallContext.reset();
        }
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethodAlwaysRun(Method method, ITestResult result) throws Exception {
        log.info("***************************************************************************************************");
        log.info("***   Ending test {}:{} {} ({} s.)", new Object[]{method.getDeclaringClass().getName(), method.getName(), result.isSuccess() ? "SUCCESS" : "!!! FAILURE !!!", (result.getEndMillis() - result.getStartMillis()) / 1000L});
        log.info("***************************************************************************************************");
        if (!this.hasFailed && !result.isSuccess()) {
            this.hasFailed = true;
        }
    }

    public void run(IHookCallBack callBack, ITestResult testResult) {
        this.assertListenerStatus();
        callBack.runTestMethod(testResult);
        this.assertListenerStatus();
    }

    protected void assertListenerStatus() {
    }

    public boolean hasFailed() {
        return this.hasFailed;
    }
}

