/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing;

import javax.inject.Inject;
import javax.sql.DataSource;
import org.killbill.billing.DBTestingHelper;
import org.killbill.billing.GuicyKillbillTestSuite;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public class GuicyKillbillTestSuiteWithEmbeddedDB
extends GuicyKillbillTestSuite {
    private static final Logger log = LoggerFactory.getLogger(GuicyKillbillTestSuiteWithEmbeddedDB.class);
    @Inject
    protected EmbeddedDB helper;
    @Inject
    protected DataSource dataSource;
    @Inject
    protected IDBI dbi;
    @Inject
    protected CacheControllerDispatcher controlCacheDispatcher;

    @BeforeSuite(groups={"slow"})
    public void beforeSuite() throws Exception {
        DBTestingHelper.get().start();
    }

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        this.cleanupAllTables();
        this.controlCacheDispatcher.clearAll();
    }

    protected void cleanupAllTables() {
        try {
            DBTestingHelper.get().getInstance().cleanupAllTables();
        }
        catch (Exception e) {
            Assert.fail((String)"Unable to clean database", (Throwable)e);
        }
    }

    @AfterSuite(groups={"slow"})
    public void afterSuite() throws Exception {
        if (this.hasFailed()) {
            log.error("**********************************************************************************************");
            log.error("*** TESTS HAVE FAILED - LEAVING DB RUNNING FOR DEBUGGING - MAKE SURE TO KILL IT ONCE DONE ****");
            log.error(DBTestingHelper.get().getInstance().getCmdLineConnectionString());
            log.error("**********************************************************************************************");
            return;
        }
        try {
            DBTestingHelper.get().getInstance().stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

