/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing;

import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import org.killbill.billing.DBTestingHelper;
import org.killbill.billing.KillbillTestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public class KillbillTestSuiteWithEmbeddedDB
extends KillbillTestSuite {
    private static final Logger log = LoggerFactory.getLogger(KillbillTestSuiteWithEmbeddedDB.class);

    @BeforeSuite(groups={"slow"})
    public void startMysqlBeforeTestSuite() throws IOException, ClassNotFoundException, SQLException, URISyntaxException {
        DBTestingHelper.get().start();
    }

    @BeforeMethod(groups={"slow"})
    public void cleanupTablesBetweenMethods() {
        try {
            DBTestingHelper.get().getInstance().cleanupAllTables();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @AfterSuite(groups={"slow"})
    public void shutdownMysqlAfterTestSuite() throws IOException, ClassNotFoundException, SQLException, URISyntaxException {
        if (this.hasFailed()) {
            log.error("**********************************************************************************************");
            log.error("*** TESTS HAVE FAILED - LEAVING DB RUNNING FOR DEBUGGING - MAKE SURE TO KILL IT ONCE DONE ****");
            log.error(DBTestingHelper.get().getInstance().getCmdLineConnectionString());
            log.error("**********************************************************************************************");
            return;
        }
        try {
            DBTestingHelper.get().getInstance().stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

