/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.api;

import com.google.common.base.Joiner;
import com.google.common.eventbus.Subscribe;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.awaitility.Awaitility;
import org.killbill.billing.events.BlockingTransitionInternalEvent;
import org.killbill.billing.events.BroadcastInternalEvent;
import org.killbill.billing.events.CustomFieldEvent;
import org.killbill.billing.events.EffectiveSubscriptionInternalEvent;
import org.killbill.billing.events.InvoiceAdjustmentInternalEvent;
import org.killbill.billing.events.InvoiceCreationInternalEvent;
import org.killbill.billing.events.InvoiceNotificationInternalEvent;
import org.killbill.billing.events.InvoicePaymentErrorInternalEvent;
import org.killbill.billing.events.InvoicePaymentInfoInternalEvent;
import org.killbill.billing.events.NullInvoiceInternalEvent;
import org.killbill.billing.events.PaymentErrorInternalEvent;
import org.killbill.billing.events.PaymentInfoInternalEvent;
import org.killbill.billing.events.PaymentPluginErrorInternalEvent;
import org.killbill.billing.events.TagDefinitionInternalEvent;
import org.killbill.billing.events.TagInternalEvent;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;

public class TestApiListener {
    private static final Logger log = LoggerFactory.getLogger(TestApiListener.class);
    private static final Joiner SPACE_JOINER = Joiner.on((String)" ");
    private static final long DELAY = 60000L;
    private final List<NextEvent> nextExpectedEvent = new Stack<NextEvent>();
    private final IDBI idbi;
    private final Clock clock;
    private boolean isListenerFailed = false;
    private String listenerFailedMsg;
    private volatile boolean completed = false;

    @Inject
    public TestApiListener(IDBI idbi, Clock clock) {
        this.idbi = idbi;
        this.clock = clock;
    }

    public void assertListenerStatus() {
        if (this.isListenerFailed) {
            log.error(this.listenerFailedMsg);
            Assert.fail((String)this.listenerFailedMsg);
        }
        try {
            Assert.assertTrue((boolean)this.isCompleted(60000L));
        }
        catch (Exception e) {
            Assert.fail((String)"assertListenerStatus didn't complete", (Throwable)e);
        }
        if (this.isListenerFailed) {
            log.error(this.listenerFailedMsg);
            Assert.fail((String)this.listenerFailedMsg);
        }
    }

    @Subscribe
    public void handleBroadcastEvents(BroadcastInternalEvent event) {
        log.info(String.format("Got BroadcastInternalEvent event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.BROADCAST_SERVICE);
        this.notifyIfStackEmpty();
    }

    @Subscribe
    public void handleEntitlementEvents(BlockingTransitionInternalEvent event) {
        log.info(String.format("Got entitlement event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.BLOCK);
        this.notifyIfStackEmpty();
    }

    @Subscribe
    public void handleSubscriptionEvents(EffectiveSubscriptionInternalEvent eventEffective) {
        log.info(String.format("Got subscription event %s", eventEffective.toString()));
        Assert.assertNotNull((Object)eventEffective.getBundleExternalKey());
        switch (eventEffective.getTransitionType()) {
            case TRANSFER: {
                this.assertEqualsNicely(NextEvent.TRANSFER);
                this.notifyIfStackEmpty();
                break;
            }
            case CREATE: {
                this.assertEqualsNicely(NextEvent.CREATE);
                this.notifyIfStackEmpty();
                break;
            }
            case CANCEL: {
                this.assertEqualsNicely(NextEvent.CANCEL);
                this.notifyIfStackEmpty();
                break;
            }
            case CHANGE: {
                this.assertEqualsNicely(NextEvent.CHANGE);
                this.notifyIfStackEmpty();
                break;
            }
            case UNCANCEL: {
                this.assertEqualsNicely(NextEvent.UNCANCEL);
                this.notifyIfStackEmpty();
                break;
            }
            case PHASE: {
                this.assertEqualsNicely(NextEvent.PHASE);
                this.notifyIfStackEmpty();
                break;
            }
            case BCD_CHANGE: {
                this.assertEqualsNicely(NextEvent.BCD_CHANGE);
                this.notifyIfStackEmpty();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected event type " + eventEffective.getRequestedTransitionTime());
            }
        }
    }

    @Subscribe
    public synchronized void processTagEvent(TagInternalEvent event) {
        log.info(String.format("Got TagInternalEvent event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.TAG);
        this.notifyIfStackEmpty();
    }

    @Subscribe
    public synchronized void processCustomFieldEvent(CustomFieldEvent event) {
        log.info(String.format("Got CustomFieldEvent event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.CUSTOM_FIELD);
        this.notifyIfStackEmpty();
    }

    @Subscribe
    public synchronized void processTagDefinitonEvent(TagDefinitionInternalEvent event) {
        log.info(String.format("Got TagDefinitionInternalEvent event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.TAG_DEFINITION);
        this.notifyIfStackEmpty();
    }

    @Subscribe
    public void handleInvoiceNotificationEvents(InvoiceNotificationInternalEvent event) {
        log.info(String.format("Got Invoice notification event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.INVOICE_NOTIFICATION);
        this.notifyIfStackEmpty();
    }

    @Subscribe
    public void handleNullInvoiceEvents(NullInvoiceInternalEvent event) {
        log.info(String.format("Got Null Invoice event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.NULL_INVOICE);
        this.notifyIfStackEmpty();
    }

    @Subscribe
    public void handleInvoiceEvents(InvoiceCreationInternalEvent event) {
        log.info(String.format("Got Invoice event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.INVOICE);
        this.notifyIfStackEmpty();
    }

    @Subscribe
    public void handleInvoiceAdjustmentEvents(InvoiceAdjustmentInternalEvent event) {
        log.info(String.format("Got Invoice adjustment event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.INVOICE_ADJUSTMENT);
        this.notifyIfStackEmpty();
    }

    @Subscribe
    public void handleInvoicePaymentEvents(InvoicePaymentInfoInternalEvent event) {
        log.info(String.format("Got InvoicePaymentInfo event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.INVOICE_PAYMENT);
        this.notifyIfStackEmpty();
    }

    @Subscribe
    public void handleInvoicePaymentErrorEvents(InvoicePaymentErrorInternalEvent event) {
        log.info(String.format("Got InvoicePaymentError event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.INVOICE_PAYMENT_ERROR);
        this.notifyIfStackEmpty();
    }

    @Subscribe
    public void handlePaymentEvents(PaymentInfoInternalEvent event) {
        log.info(String.format("Got PaymentInfo event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.PAYMENT);
        this.notifyIfStackEmpty();
    }

    @Subscribe
    public void handlePaymentErrorEvents(PaymentErrorInternalEvent event) {
        log.info(String.format("Got PaymentError event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.PAYMENT_ERROR);
        this.notifyIfStackEmpty();
    }

    @Subscribe
    public void handlePaymentPluginErrorEvents(PaymentPluginErrorInternalEvent event) {
        log.info(String.format("Got PaymentPluginError event %s", event.toString()));
        this.assertEqualsNicely(NextEvent.PAYMENT_PLUGIN_ERROR);
        this.notifyIfStackEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        TestApiListener testApiListener = this;
        synchronized (testApiListener) {
            this.nextExpectedEvent.clear();
            this.completed = true;
            this.isListenerFailed = false;
            this.listenerFailedMsg = null;
        }
    }

    public void pushExpectedEvents(NextEvent ... events) {
        for (NextEvent event : events) {
            this.pushExpectedEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushExpectedEvent(NextEvent next) {
        TestApiListener testApiListener = this;
        synchronized (testApiListener) {
            this.nextExpectedEvent.add(next);
            log.debug("Stacking expected event {}, got [{}]", (Object)next, (Object)SPACE_JOINER.join(this.nextExpectedEvent));
            this.completed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleted(long timeout) {
        TestApiListener testApiListener = this;
        synchronized (testApiListener) {
            long before;
            long after;
            long waitTimeMs = timeout;
            do {
                try {
                    before = System.currentTimeMillis();
                    this.wait(100L);
                    if (this.completed) {
                        Awaitility.await().atMost(timeout, TimeUnit.MILLISECONDS).until((Callable)new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                long pending = (Long)TestApiListener.this.idbi.withHandle((HandleCallback)new PendingBusOrNotificationCallback(TestApiListener.this.clock));
                                log.debug("Events still in processing: {}", (Object)pending);
                                return pending == 0L;
                            }
                        });
                        return this.completed;
                    }
                    after = System.currentTimeMillis();
                }
                catch (Exception ignore) {
                    long pending = (Long)this.idbi.withHandle((HandleCallback)new PendingBusOrNotificationCallback(this.clock));
                    log.error("isCompleted : Received all events but found remaining unprocessed bus events/notifications =  {}", (Object)pending);
                    return false;
                }
            } while ((waitTimeMs -= after - before) > 0L && !this.completed);
        }
        if (!this.completed) {
            Joiner joiner = Joiner.on((String)" ");
            log.error("TestApiListener did not complete in " + timeout + " ms, remaining events are " + joiner.join(this.nextExpectedEvent));
        }
        return this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIfStackEmpty() {
        log.debug("TestApiListener notifyIfStackEmpty ENTER");
        TestApiListener testApiListener = this;
        synchronized (testApiListener) {
            if (this.nextExpectedEvent.isEmpty()) {
                log.debug("notifyIfStackEmpty EMPTY");
                this.completed = true;
                this.notify();
            }
        }
        log.debug("TestApiListener notifyIfStackEmpty EXIT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertEqualsNicely(NextEvent received) {
        TestApiListener testApiListener = this;
        synchronized (testApiListener) {
            boolean foundIt = false;
            Iterator<NextEvent> it = this.nextExpectedEvent.iterator();
            while (it.hasNext()) {
                NextEvent ev = it.next();
                if (ev != received) continue;
                it.remove();
                foundIt = true;
                log.debug("Found expected event {}. Yeah!", (Object)received);
                break;
            }
            if (!foundIt) {
                log.error("Received unexpected event " + (Object)((Object)received) + "; remaining expected events [" + SPACE_JOINER.join(this.nextExpectedEvent) + "]");
                this.failed("TestApiListener [ApiListenerStatus]: Received unexpected event " + (Object)((Object)received) + "; remaining expected events [" + SPACE_JOINER.join(this.nextExpectedEvent) + "]");
            }
        }
    }

    private void failed(String msg) {
        this.isListenerFailed = true;
        this.listenerFailedMsg = msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PendingBusOrNotificationCallback
    implements HandleCallback<Long> {
        private final Clock clock;

        public PendingBusOrNotificationCallback(Clock clock) {
            this.clock = clock;
        }

        public Long withHandle(Handle handle) throws Exception {
            return (Long)((Map)handle.select("select count(distinct record_id) count from bus_events", new Object[0]).get(0)).get("count") + (Long)((Map)handle.select("select count(distinct record_id) count from notifications where effective_date < ?", new Object[]{this.clock.getUTCNow().toDate()}).get(0)).get("count") + (Long)((Map)handle.select("select count(distinct record_id) count from notifications where processing_state = 'IN_PROCESSING'", new Object[0]).get(0)).get("count");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NextEvent {
        BROADCAST_SERVICE,
        CREATE,
        TRANSFER,
        CHANGE,
        CANCEL,
        UNCANCEL,
        PAUSE,
        RESUME,
        PHASE,
        BLOCK,
        NULL_INVOICE,
        INVOICE,
        INVOICE_NOTIFICATION,
        INVOICE_ADJUSTMENT,
        INVOICE_PAYMENT,
        INVOICE_PAYMENT_ERROR,
        PAYMENT,
        PAYMENT_ERROR,
        PAYMENT_PLUGIN_ERROR,
        TAG,
        TAG_DEFINITION,
        CUSTOM_FIELD,
        BCD_CHANGE;

    }
}

