/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.callcontext;

import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.util.callcontext.CallOrigin;
import org.killbill.billing.util.callcontext.UserType;

public class MutableInternalCallContext
extends InternalCallContext {
    private final Long initialAccountRecordId;
    private final Long initialTenantRecordId;
    private final DateTimeZone initialReferenceDateTimeZone;
    private final LocalTime initialReferenceTime;
    private final DateTime initialCreatedDate;
    private final DateTime initialUpdatedDate;
    private Long accountRecordId;
    private Long tenantRecordId;
    private DateTimeZone fixedOffsetTimeZone;
    private LocalTime referenceTime;
    private DateTime createdDate;
    private DateTime updatedDate;

    public MutableInternalCallContext(Long tenantRecordId, @Nullable Long accountRecordId, @Nullable DateTimeZone fixedOffsetTimeZone, @Nullable DateTime referenceTime, UUID userToken, String userName, CallOrigin callOrigin, UserType userType, String reasonCode, String comment, DateTime createdDate, DateTime updatedDate) {
        super(tenantRecordId, accountRecordId, fixedOffsetTimeZone, referenceTime, userToken, userName, callOrigin, userType, reasonCode, comment, createdDate, updatedDate);
        this.initialAccountRecordId = accountRecordId;
        this.initialTenantRecordId = tenantRecordId;
        this.initialReferenceDateTimeZone = fixedOffsetTimeZone;
        this.initialReferenceTime = super.getReferenceTime();
        this.initialCreatedDate = createdDate;
        this.initialUpdatedDate = updatedDate;
        this.reset();
    }

    public Long getAccountRecordId() {
        return this.accountRecordId;
    }

    public void setAccountRecordId(Long accountRecordId) {
        this.accountRecordId = accountRecordId;
    }

    public Long getTenantRecordId() {
        return this.tenantRecordId;
    }

    public void setTenantRecordId(Long tenantRecordId) {
        this.tenantRecordId = tenantRecordId;
    }

    public DateTimeZone getFixedOffsetTimeZone() {
        return this.fixedOffsetTimeZone;
    }

    public void setFixedOffsetTimeZone(DateTimeZone fixedOffsetTimeZone) {
        this.fixedOffsetTimeZone = fixedOffsetTimeZone;
    }

    public LocalTime getReferenceTime() {
        return this.referenceTime;
    }

    public void setReferenceTime(LocalTime referenceTime) {
        this.referenceTime = referenceTime;
    }

    public void setReferenceTime(DateTime referenceDateTime) {
        this.referenceTime = this.computeReferenceTime(referenceDateTime);
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(DateTime createdDate) {
        this.createdDate = createdDate;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(DateTime updatedDate) {
        this.updatedDate = updatedDate;
    }

    public void reset() {
        this.setAccountRecordId(this.initialAccountRecordId);
        this.setTenantRecordId(this.initialTenantRecordId);
        this.setFixedOffsetTimeZone(this.initialReferenceDateTimeZone);
        this.setReferenceTime(this.initialReferenceTime);
        this.setCreatedDate(this.initialCreatedDate);
        this.setUpdatedDate(this.initialUpdatedDate);
    }
}

