/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.mock;

import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.MutableAccountData;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.util.account.AccountDateTimeUtils;
import org.killbill.billing.util.entity.Entity;

public class MockAccountBuilder {
    private final UUID id;
    private String externalKey = "";
    private String email = "";
    private String name = "";
    private int firstNameLength;
    private Currency currency = Currency.USD;
    private UUID parentAccountId;
    private boolean isPaymentDelegatedToParent = false;
    private int billingCycleDayLocal;
    private UUID paymentMethodId;
    private DateTimeZone timeZone = DateTimeZone.UTC;
    private String locale = "";
    private String address1 = "";
    private String address2 = "";
    private String companyName = "";
    private String city = "";
    private String stateOrProvince = "";
    private String country = "";
    private String postalCode = "";
    private String phone = "";
    private String notes = "";
    private boolean migrated;
    private boolean isNotifiedForInvoices;
    private DateTime createdDate = new DateTime(DateTimeZone.UTC);
    private DateTime updatedDate = new DateTime(DateTimeZone.UTC);

    public MockAccountBuilder() {
        this(UUID.randomUUID());
    }

    public MockAccountBuilder(UUID id) {
        this.id = id;
    }

    public MockAccountBuilder(AccountData data) {
        this.address1(data.getAddress1());
        this.address2(data.getAddress2());
        this.billingCycleDayLocal(data.getBillCycleDayLocal());
        this.city(data.getCity());
        this.companyName(data.getCompanyName());
        this.country(data.getCountry());
        this.currency(data.getCurrency());
        this.parentAccountId(data.getParentAccountId());
        this.isPaymentDelegatedToParent(data.isPaymentDelegatedToParent());
        this.email(data.getEmail());
        this.externalKey(data.getExternalKey());
        this.firstNameLength(data.getFirstNameLength());
        this.isNotifiedForInvoices(data.isNotifiedForInvoices());
        this.locale(data.getLocale());
        this.migrated(data.isMigrated());
        this.name(data.getName());
        this.paymentMethodId(data.getPaymentMethodId());
        this.phone(data.getPhone());
        this.notes(data.getNotes());
        this.postalCode(data.getPostalCode());
        this.stateOrProvince(data.getStateOrProvince());
        this.timeZone(data.getTimeZone());
        if (data instanceof Account) {
            this.id = ((Account)data).getId();
            this.createdDate(((Account)data).getCreatedDate());
            this.updatedDate(((Account)data).getUpdatedDate());
        } else {
            this.id = UUID.randomUUID();
        }
    }

    public MockAccountBuilder externalKey(String externalKey) {
        this.externalKey = externalKey;
        return this;
    }

    public MockAccountBuilder email(String email) {
        this.email = email;
        return this;
    }

    public MockAccountBuilder name(String name) {
        this.name = name;
        return this;
    }

    public MockAccountBuilder firstNameLength(int firstNameLength) {
        this.firstNameLength = firstNameLength;
        return this;
    }

    public MockAccountBuilder billingCycleDayLocal(int billingCycleDayLocal) {
        this.billingCycleDayLocal = billingCycleDayLocal;
        return this;
    }

    public MockAccountBuilder currency(Currency currency) {
        this.currency = currency;
        return this;
    }

    public MockAccountBuilder parentAccountId(UUID parentAccountId) {
        this.parentAccountId = parentAccountId;
        return this;
    }

    public MockAccountBuilder isPaymentDelegatedToParent(boolean isPaymentDelegatedToParent) {
        this.isPaymentDelegatedToParent = isPaymentDelegatedToParent;
        return this;
    }

    public MockAccountBuilder paymentMethodId(UUID paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    public MockAccountBuilder timeZone(DateTimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public MockAccountBuilder locale(String locale) {
        this.locale = locale;
        return this;
    }

    public MockAccountBuilder address1(String address1) {
        this.address1 = address1;
        return this;
    }

    public MockAccountBuilder address2(String address2) {
        this.address2 = address2;
        return this;
    }

    public MockAccountBuilder companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    public MockAccountBuilder city(String city) {
        this.city = city;
        return this;
    }

    public MockAccountBuilder stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    public MockAccountBuilder postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public MockAccountBuilder country(String country) {
        this.country = country;
        return this;
    }

    public MockAccountBuilder phone(String phone) {
        this.phone = phone;
        return this;
    }

    public MockAccountBuilder notes(String notes) {
        this.notes = notes;
        return this;
    }

    public MockAccountBuilder migrated(boolean migrated) {
        this.migrated = migrated;
        return this;
    }

    public MockAccountBuilder isNotifiedForInvoices(boolean isNotifiedForInvoices) {
        this.isNotifiedForInvoices = isNotifiedForInvoices;
        return this;
    }

    public MockAccountBuilder createdDate(DateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    public MockAccountBuilder updatedDate(DateTime updatedDate) {
        this.updatedDate = updatedDate;
        return this;
    }

    public Account build() {
        return new Account(){

            public DateTime getCreatedDate() {
                return MockAccountBuilder.this.createdDate;
            }

            public DateTime getUpdatedDate() {
                return MockAccountBuilder.this.updatedDate;
            }

            public String getExternalKey() {
                return MockAccountBuilder.this.externalKey;
            }

            public String getName() {
                return MockAccountBuilder.this.name;
            }

            public Integer getFirstNameLength() {
                return MockAccountBuilder.this.firstNameLength;
            }

            public String getEmail() {
                return MockAccountBuilder.this.email;
            }

            public Integer getBillCycleDayLocal() {
                return MockAccountBuilder.this.billingCycleDayLocal;
            }

            public Currency getCurrency() {
                return MockAccountBuilder.this.currency;
            }

            public UUID getPaymentMethodId() {
                return MockAccountBuilder.this.paymentMethodId;
            }

            public DateTimeZone getTimeZone() {
                return MockAccountBuilder.this.timeZone;
            }

            public DateTimeZone getFixedOffsetTimeZone() {
                return AccountDateTimeUtils.getFixedOffsetTimeZone((Account)this);
            }

            public DateTime getReferenceTime() {
                return AccountDateTimeUtils.getReferenceDateTime((Entity)this);
            }

            public String getLocale() {
                return MockAccountBuilder.this.locale;
            }

            public String getAddress1() {
                return MockAccountBuilder.this.address1;
            }

            public String getAddress2() {
                return MockAccountBuilder.this.address2;
            }

            public String getCompanyName() {
                return MockAccountBuilder.this.companyName;
            }

            public String getCity() {
                return MockAccountBuilder.this.city;
            }

            public String getStateOrProvince() {
                return MockAccountBuilder.this.stateOrProvince;
            }

            public String getPostalCode() {
                return MockAccountBuilder.this.postalCode;
            }

            public String getCountry() {
                return MockAccountBuilder.this.country;
            }

            public String getPhone() {
                return MockAccountBuilder.this.phone;
            }

            public String getNotes() {
                return MockAccountBuilder.this.notes;
            }

            public Boolean isMigrated() {
                return MockAccountBuilder.this.migrated;
            }

            public Boolean isNotifiedForInvoices() {
                return MockAccountBuilder.this.isNotifiedForInvoices;
            }

            public UUID getParentAccountId() {
                return MockAccountBuilder.this.parentAccountId;
            }

            public Boolean isPaymentDelegatedToParent() {
                return MockAccountBuilder.this.isPaymentDelegatedToParent;
            }

            public UUID getId() {
                return MockAccountBuilder.this.id;
            }

            public MutableAccountData toMutableAccountData() {
                throw new UnsupportedOperationException();
            }

            public Account mergeWithDelegate(Account delegate) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

