/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.mock;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.events.BusEventBase;
import org.killbill.billing.events.BusInternalEvent;
import org.killbill.billing.events.EffectiveSubscriptionInternalEvent;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;

public class MockEffectiveSubscriptionEvent
extends BusEventBase
implements EffectiveSubscriptionInternalEvent {
    private final Long totalOrdering;
    private final UUID subscriptionId;
    private final UUID bundleId;
    private final String bundleExternalKey;
    private final UUID eventId;
    private final DateTime requestedTransitionTime;
    private final DateTime effectiveTransitionTime;
    private final Entitlement.EntitlementState previousState;
    private final String previousPriceList;
    private final Integer previousBillCycleDayLocal;
    private final String previousPlan;
    private final String previousPhase;
    private final Entitlement.EntitlementState nextState;
    private final String nextPriceList;
    private final Integer nextBillCycleDayLocal;
    private final String nextPlan;
    private final String nextPhase;
    private final Integer remainingEventsForUserOperation;
    private final UUID userToken;
    private final SubscriptionBaseTransitionType transitionType;
    private final DateTime startDate;

    @JsonCreator
    public MockEffectiveSubscriptionEvent(@JsonProperty(value="eventId") UUID eventId, @JsonProperty(value="subscriptionId") UUID subscriptionId, @JsonProperty(value="bundleId") UUID bundleId, @JsonProperty(value="bundleExternalKey") String bundleExternalKey, @JsonProperty(value="requestedTransitionTime") DateTime requestedTransitionTime, @JsonProperty(value="effectiveTransitionTime") DateTime effectiveTransitionTime, @JsonProperty(value="previousState") Entitlement.EntitlementState previousState, @JsonProperty(value="previousPlan") String previousPlan, @JsonProperty(value="previousPhase") String previousPhase, @JsonProperty(value="previousPriceList") String previousPriceList, @JsonProperty(value="previousBillCycleDayLocal") Integer previousBillCycleDayLocal, @JsonProperty(value="nextState") Entitlement.EntitlementState nextState, @JsonProperty(value="nextPlan") String nextPlan, @JsonProperty(value="nextPhase") String nextPhase, @JsonProperty(value="nextPriceList") String nextPriceList, @JsonProperty(value="nextBillCycleDayLocal") Integer nextBillCycleDayLocal, @JsonProperty(value="totalOrdering") Long totalOrdering, @JsonProperty(value="transitionType") SubscriptionBaseTransitionType transitionType, @JsonProperty(value="remainingEventsForUserOperation") Integer remainingEventsForUserOperation, @JsonProperty(value="startDate") DateTime startDate, @JsonProperty(value="searchKey1") Long searchKey1, @JsonProperty(value="searchKey2") Long searchKey2, @JsonProperty(value="userToken") UUID userToken) {
        super(searchKey1, searchKey2, userToken);
        this.eventId = eventId;
        this.subscriptionId = subscriptionId;
        this.bundleId = bundleId;
        this.bundleExternalKey = bundleExternalKey;
        this.requestedTransitionTime = requestedTransitionTime;
        this.effectiveTransitionTime = effectiveTransitionTime;
        this.previousState = previousState;
        this.previousPriceList = previousPriceList;
        this.previousBillCycleDayLocal = previousBillCycleDayLocal;
        this.previousPlan = previousPlan;
        this.previousPhase = previousPhase;
        this.nextState = nextState;
        this.nextPlan = nextPlan;
        this.nextPriceList = nextPriceList;
        this.nextBillCycleDayLocal = nextBillCycleDayLocal;
        this.nextPhase = nextPhase;
        this.totalOrdering = totalOrdering;
        this.userToken = userToken;
        this.transitionType = transitionType;
        this.remainingEventsForUserOperation = remainingEventsForUserOperation;
        this.startDate = startDate;
    }

    @JsonIgnore
    public BusInternalEvent.BusInternalEventType getBusEventType() {
        return BusInternalEvent.BusInternalEventType.SUBSCRIPTION_TRANSITION;
    }

    @JsonProperty(value="eventId")
    public UUID getId() {
        return this.eventId;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public String getBundleExternalKey() {
        return this.bundleExternalKey;
    }

    public Entitlement.EntitlementState getPreviousState() {
        return this.previousState;
    }

    public String getPreviousPlan() {
        return this.previousPlan;
    }

    public String getPreviousPhase() {
        return this.previousPhase;
    }

    public Integer getPreviousBillCycleDayLocal() {
        return this.previousBillCycleDayLocal;
    }

    public String getNextPlan() {
        return this.nextPlan;
    }

    public String getNextPhase() {
        return this.nextPhase;
    }

    public Entitlement.EntitlementState getNextState() {
        return this.nextState;
    }

    public String getPreviousPriceList() {
        return this.previousPriceList;
    }

    public String getNextPriceList() {
        return this.nextPriceList;
    }

    public Integer getNextBillCycleDayLocal() {
        return this.nextBillCycleDayLocal;
    }

    public Integer getRemainingEventsForUserOperation() {
        return this.remainingEventsForUserOperation;
    }

    public DateTime getRequestedTransitionTime() {
        return this.requestedTransitionTime;
    }

    public DateTime getEffectiveTransitionTime() {
        return this.effectiveTransitionTime;
    }

    public Long getTotalOrdering() {
        return this.totalOrdering;
    }

    public SubscriptionBaseTransitionType getTransitionType() {
        return this.transitionType;
    }

    @JsonProperty(value="startDate")
    public DateTime getSubscriptionStartDate() {
        return this.startDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
        result = 31 * result + (this.effectiveTransitionTime == null ? 0 : this.effectiveTransitionTime.hashCode());
        result = 31 * result + (this.eventId == null ? 0 : this.eventId.hashCode());
        result = 31 * result + (this.nextPhase == null ? 0 : this.nextPhase.hashCode());
        result = 31 * result + (this.nextPlan == null ? 0 : this.nextPlan.hashCode());
        result = 31 * result + (this.nextPriceList == null ? 0 : this.nextPriceList.hashCode());
        result = 31 * result + (this.nextState == null ? 0 : this.nextState.hashCode());
        result = 31 * result + (this.previousPhase == null ? 0 : this.previousPhase.hashCode());
        result = 31 * result + (this.previousPlan == null ? 0 : this.previousPlan.hashCode());
        result = 31 * result + (this.previousPriceList == null ? 0 : this.previousPriceList.hashCode());
        result = 31 * result + (this.previousState == null ? 0 : this.previousState.hashCode());
        result = 31 * result + (this.remainingEventsForUserOperation == null ? 0 : this.remainingEventsForUserOperation.hashCode());
        result = 31 * result + (this.requestedTransitionTime == null ? 0 : this.requestedTransitionTime.hashCode());
        result = 31 * result + (this.subscriptionId == null ? 0 : this.subscriptionId.hashCode());
        result = 31 * result + (this.totalOrdering == null ? 0 : this.totalOrdering.hashCode());
        result = 31 * result + (this.transitionType == null ? 0 : this.transitionType.hashCode());
        result = 31 * result + (this.userToken == null ? 0 : this.userToken.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MockEffectiveSubscriptionEvent other = (MockEffectiveSubscriptionEvent)((Object)obj);
        if (this.bundleId == null ? other.bundleId != null : !this.bundleId.equals(other.bundleId)) {
            return false;
        }
        if (this.effectiveTransitionTime == null ? other.effectiveTransitionTime != null : this.effectiveTransitionTime.compareTo((ReadableInstant)other.effectiveTransitionTime) != 0) {
            return false;
        }
        if (this.eventId == null ? other.eventId != null : !this.eventId.equals(other.eventId)) {
            return false;
        }
        if (this.nextPhase == null ? other.nextPhase != null : !this.nextPhase.equals(other.nextPhase)) {
            return false;
        }
        if (this.nextPlan == null ? other.nextPlan != null : !this.nextPlan.equals(other.nextPlan)) {
            return false;
        }
        if (this.nextPriceList == null ? other.nextPriceList != null : !this.nextPriceList.equals(other.nextPriceList)) {
            return false;
        }
        if (this.nextState != other.nextState) {
            return false;
        }
        if (this.previousPhase == null ? other.previousPhase != null : !this.previousPhase.equals(other.previousPhase)) {
            return false;
        }
        if (this.previousPlan == null ? other.previousPlan != null : !this.previousPlan.equals(other.previousPlan)) {
            return false;
        }
        if (this.previousPriceList == null ? other.previousPriceList != null : !this.previousPriceList.equals(other.previousPriceList)) {
            return false;
        }
        if (this.previousState != other.previousState) {
            return false;
        }
        if (this.remainingEventsForUserOperation == null ? other.remainingEventsForUserOperation != null : !this.remainingEventsForUserOperation.equals(other.remainingEventsForUserOperation)) {
            return false;
        }
        if (this.requestedTransitionTime == null ? other.requestedTransitionTime != null : this.requestedTransitionTime.compareTo((ReadableInstant)other.requestedTransitionTime) != 0) {
            return false;
        }
        if (this.subscriptionId == null ? other.subscriptionId != null : !this.subscriptionId.equals(other.subscriptionId)) {
            return false;
        }
        if (this.totalOrdering == null ? other.totalOrdering != null : !this.totalOrdering.equals(other.totalOrdering)) {
            return false;
        }
        if (this.transitionType != other.transitionType) {
            return false;
        }
        return !(this.userToken == null ? other.userToken != null : !this.userToken.equals(other.userToken));
    }
}

