/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.mock;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.killbill.billing.catalog.api.Limit;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockProduct
implements Product {
    private final String name;
    private final ProductCategory category;
    private final String catalogName;
    private final Collection<Product> included;
    private final Collection<Product> available;

    public MockProduct() {
        this("TestProduct", ProductCategory.BASE, "Vehicules");
    }

    public MockProduct(String name, ProductCategory category, String catalogName) {
        this(name, category, catalogName, null, null);
    }

    public MockProduct(String name, ProductCategory category, String catalogName, Product[] included, Product[] available) {
        this.name = name;
        this.category = category;
        this.catalogName = catalogName;
        this.included = ImmutableList.copyOf((Object[])included);
        this.available = ImmutableList.copyOf((Object[])available);
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public ProductCategory getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Product> getAvailable() {
        return this.available;
    }

    public Collection<Product> getIncluded() {
        return this.included;
    }

    public static MockProduct createBicycle() {
        return new MockProduct("Bicycle", ProductCategory.BASE, "Vehcles");
    }

    public static MockProduct createPickup() {
        return new MockProduct("Pickup", ProductCategory.BASE, "Vehcles");
    }

    public static MockProduct createSportsCar() {
        return new MockProduct("SportsCar", ProductCategory.BASE, "Vehcles");
    }

    public static MockProduct createJet() {
        return new MockProduct("Jet", ProductCategory.BASE, "Vehcles");
    }

    public static MockProduct createHorn() {
        return new MockProduct("Horn", ProductCategory.ADD_ON, "Vehcles");
    }

    public static MockProduct createSpotlight() {
        return new MockProduct("spotlight", ProductCategory.ADD_ON, "Vehcles");
    }

    public static MockProduct createRedPaintJob() {
        return new MockProduct("RedPaintJob", ProductCategory.ADD_ON, "Vehcles");
    }

    public static Product[] createAll() {
        return new MockProduct[]{MockProduct.createBicycle(), MockProduct.createPickup(), MockProduct.createSportsCar(), MockProduct.createJet(), MockProduct.createHorn(), MockProduct.createRedPaintJob()};
    }

    public Limit[] getLimits() {
        return new Limit[0];
    }

    public boolean compliesWithLimits(String unit, double value) {
        return false;
    }
}

