/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.mock;

import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.mock.MockPriceList;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.user.SubscriptionBaseApiException;
import org.killbill.billing.subscription.api.user.SubscriptionBaseTransition;
import org.killbill.billing.util.callcontext.CallContext;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockSubscription
implements SubscriptionBase {
    private final UUID id;
    private final UUID bundleId;
    private final Entitlement.EntitlementState state;
    private Plan plan;
    private final PlanPhase phase;
    private final DateTime startDate;
    private final DateTime firstRecurringNonZeroChargeDate;
    private SubscriptionBase sub;

    public MockSubscription(UUID id, UUID bundleId, Plan plan, DateTime startDate, DateTime firstRecurringNonZeroChargeDate) {
        this.id = id;
        this.bundleId = bundleId;
        this.state = Entitlement.EntitlementState.ACTIVE;
        this.plan = plan;
        this.phase = null;
        this.startDate = startDate;
        this.firstRecurringNonZeroChargeDate = firstRecurringNonZeroChargeDate;
        this.sub = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
    }

    public boolean cancel(CallContext context) throws SubscriptionBaseApiException {
        return this.sub.cancel(context);
    }

    public boolean cancelWithDate(DateTime requestedDate, CallContext context) throws SubscriptionBaseApiException {
        return this.sub.cancelWithDate(requestedDate, context);
    }

    public boolean cancelWithPolicy(BillingActionPolicy policy, int accountBillCycleDayLocal, CallContext context) throws SubscriptionBaseApiException {
        return this.sub.cancelWithPolicy(policy, accountBillCycleDayLocal, context);
    }

    public boolean uncancel(CallContext context) throws SubscriptionBaseApiException {
        return this.sub.uncancel(context);
    }

    public DateTime changePlan(PlanSpecifier spec, List<PlanPhasePriceOverride> overrides, CallContext context) throws SubscriptionBaseApiException {
        return this.sub.changePlan(spec, overrides, context);
    }

    public DateTime changePlanWithDate(PlanSpecifier spec, List<PlanPhasePriceOverride> overrides, DateTime requestedDate, CallContext context) throws SubscriptionBaseApiException {
        return this.sub.changePlanWithDate(spec, overrides, requestedDate, context);
    }

    public DateTime changePlanWithPolicy(PlanSpecifier spec, List<PlanPhasePriceOverride> overrides, BillingActionPolicy policy, CallContext context) throws SubscriptionBaseApiException {
        return this.sub.changePlanWithPolicy(spec, overrides, policy, context);
    }

    public UUID getId() {
        return this.id;
    }

    public DateTime getCreatedDate() {
        throw new UnsupportedOperationException();
    }

    public DateTime getUpdatedDate() {
        throw new UnsupportedOperationException();
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public Entitlement.EntitlementState getState() {
        return this.state;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getEndDate() {
        return this.sub.getEndDate();
    }

    public Plan getCurrentPlan() {
        return this.plan;
    }

    public PriceList getCurrentPriceList() {
        return new MockPriceList();
    }

    public PlanPhase getCurrentPhase() {
        return this.phase;
    }

    public DateTime getChargedThroughDate() {
        return this.sub.getChargedThroughDate();
    }

    public DateTime getDateOfFirstRecurringNonZeroCharge() {
        return this.firstRecurringNonZeroChargeDate;
    }

    public boolean isMigrated() {
        return false;
    }

    public ProductCategory getCategory() {
        return this.sub.getCategory();
    }

    public Integer getBillCycleDayLocal() {
        return null;
    }

    public DateTime getFutureEndDate() {
        return this.sub.getFutureEndDate();
    }

    public Entitlement.EntitlementSourceType getSourceType() {
        return this.sub.getSourceType();
    }

    public Product getLastActiveProduct() {
        return this.sub.getLastActiveProduct();
    }

    public PriceList getLastActivePriceList() {
        return this.sub.getLastActivePriceList();
    }

    public ProductCategory getLastActiveCategory() {
        return this.sub.getLastActiveCategory();
    }

    public BillingPeriod getLastActiveBillingPeriod() {
        return null;
    }

    public Plan getLastActivePlan() {
        return this.sub.getLastActivePlan();
    }

    public PlanPhase getLastActivePhase() {
        return this.sub.getLastActivePhase();
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    public SubscriptionBaseTransition getPendingTransition() {
        return null;
    }

    public SubscriptionBaseTransition getPreviousTransition() {
        return null;
    }

    public List<SubscriptionBaseTransition> getAllTransitions() {
        return null;
    }
}

