/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.mock.api;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountEmail;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.mock.MockAccountBuilder;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.DefaultPagination;
import org.killbill.billing.util.entity.Pagination;
import org.testng.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockAccountUserApi
implements AccountUserApi {
    private final ConcurrentLinkedQueue<Account> accounts = new ConcurrentLinkedQueue();

    public Account createAccountFromParams(UUID id, String externalKey, String email, String name, int firstNameLength, Currency currency, int billCycleDayLocal, UUID paymentMethodId, DateTimeZone timeZone, String locale, String address1, String address2, String companyName, String city, String stateOrProvince, String country, String postalCode, String phone, String notes) {
        Account result = new MockAccountBuilder(id).externalKey(externalKey).email(email).name(name).firstNameLength(firstNameLength).currency(currency).billingCycleDayLocal(billCycleDayLocal).paymentMethodId(paymentMethodId).timeZone(timeZone).locale(locale).address1(address1).address2(address2).companyName(companyName).city(city).stateOrProvince(stateOrProvince).country(country).postalCode(postalCode).phone(phone).notes(notes).isNotifiedForInvoices(false).build();
        this.accounts.add(result);
        return result;
    }

    public Account createAccount(AccountData data, CallContext context) throws AccountApiException {
        Account result = new MockAccountBuilder(data).build();
        this.accounts.add(result);
        return result;
    }

    public Account getAccountByKey(String key, TenantContext context) {
        for (Account account : this.accounts) {
            if (!key.equals(account.getExternalKey())) continue;
            return account;
        }
        return null;
    }

    public Account getAccountById(UUID uid, TenantContext context) {
        for (Account account : this.accounts) {
            if (!uid.equals(account.getId())) continue;
            return account;
        }
        return null;
    }

    public Pagination<Account> searchAccounts(String searchKey, Long offset, Long limit, TenantContext tenantContext) {
        LinkedList<Account> results = new LinkedList<Account>();
        for (Account account : this.accounts) {
            if (!(account.getName() != null && account.getName().contains(searchKey) || account.getEmail() != null && account.getEmail().contains(searchKey) || account.getExternalKey() != null && account.getExternalKey().contains(searchKey)) && (account.getCompanyName() == null || !account.getCompanyName().contains(searchKey))) continue;
            results.add(account);
        }
        return DefaultPagination.build((Long)offset, (Long)limit, (Integer)this.accounts.size(), results);
    }

    public Pagination<Account> getAccounts(Long offset, Long limit, TenantContext context) {
        return DefaultPagination.build((Long)offset, (Long)limit, this.accounts);
    }

    public UUID getIdFromKey(String externalKey, TenantContext context) {
        for (Account account : this.accounts) {
            if (!externalKey.equals(account.getExternalKey())) continue;
            return account.getId();
        }
        return null;
    }

    public List<AccountEmail> getEmails(UUID accountId, TenantContext context) {
        throw new UnsupportedOperationException();
    }

    public void addEmail(UUID accountId, AccountEmail email, CallContext context) {
        throw new UnsupportedOperationException();
    }

    public void removeEmail(UUID accountId, AccountEmail email, CallContext context) {
        throw new UnsupportedOperationException();
    }

    public void updateAccount(Account account, CallContext context) {
        Iterator<Account> iterator = this.accounts.iterator();
        while (iterator.hasNext()) {
            Account account1 = iterator.next();
            if (!account.getId().equals(account1.getId())) continue;
            iterator.remove();
            break;
        }
        try {
            this.createAccount((AccountData)account, context);
        }
        catch (AccountApiException e) {
            Assert.fail((String)e.toString());
        }
    }

    public void updateAccount(String key, AccountData accountData, CallContext context) throws AccountApiException {
        throw new UnsupportedOperationException();
    }

    public void updateAccount(UUID accountId, AccountData accountData, CallContext context) throws AccountApiException {
        throw new UnsupportedOperationException();
    }

    public List<Account> getChildrenAccounts(UUID uuid, TenantContext tenantContext) throws AccountApiException {
        throw new UnsupportedOperationException();
    }
}

