/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.mock.glue;

import org.killbill.billing.entitlement.EntitlementInternalApi;
import org.killbill.billing.entitlement.api.EntitlementApi;
import org.killbill.billing.entitlement.api.SubscriptionApi;
import org.killbill.billing.glue.EntitlementModule;
import org.killbill.billing.junction.BlockingInternalApi;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.util.glue.KillBillModule;
import org.mockito.Mockito;

public class MockEntitlementModule
extends KillBillModule
implements EntitlementModule {
    private final EntitlementApi entitlementApi = (EntitlementApi)Mockito.mock(EntitlementApi.class);
    private final EntitlementInternalApi entitlementInternalApi = (EntitlementInternalApi)Mockito.mock(EntitlementInternalApi.class);
    private final SubscriptionApi subscriptionApi = (SubscriptionApi)Mockito.mock(SubscriptionApi.class);
    protected final BlockingInternalApi blockingApi;

    public MockEntitlementModule(KillbillConfigSource configSource) {
        this(configSource, (BlockingInternalApi)Mockito.mock(BlockingInternalApi.class));
    }

    public MockEntitlementModule(KillbillConfigSource configSource, BlockingInternalApi blockingApi) {
        super(configSource);
        this.blockingApi = blockingApi;
    }

    protected void configure() {
        this.installBlockingStateDao();
        this.installBlockingApi();
        this.installEntitlementApi();
        this.installEntitlementInternalApi();
        this.installBlockingChecker();
    }

    public void installBlockingStateDao() {
    }

    public void installBlockingApi() {
        this.bind(BlockingInternalApi.class).toInstance((Object)this.blockingApi);
    }

    public void installEntitlementApi() {
        this.bind(EntitlementApi.class).toInstance((Object)this.entitlementApi);
    }

    public void installEntitlementInternalApi() {
        this.bind(EntitlementInternalApi.class).toInstance((Object)this.entitlementInternalApi);
    }

    public void installSubscriptionApi() {
        this.bind(SubscriptionApi.class).toInstance((Object)this.subscriptionApi);
    }

    public void installBlockingChecker() {
    }
}

