/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.Map;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.util.PluginProperties;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPluginProperties
extends UtilTestSuiteNoDB {
    private final List<PluginProperty> pluginProperties1 = PluginProperties.buildPluginProperties((Map)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)12L));
    private final List<PluginProperty> pluginProperties2 = PluginProperties.buildPluginProperties((Map)ImmutableMap.of((Object)"foo", (Object)"override", (Object)"baz2", (Object)"something else"));

    @Test(groups={"fast"})
    public void testMerge() throws Exception {
        ImmutableList pluginPropertiesRaw = ImmutableList.copyOf((Iterable)PluginProperties.merge((Iterable[])new Iterable[]{this.pluginProperties1, this.pluginProperties2}));
        List<PluginProperty> pluginProperties = this.sort((Iterable<PluginProperty>)pluginPropertiesRaw);
        Assert.assertEquals((int)pluginProperties.size(), (int)3);
        Assert.assertEquals((String)pluginProperties.get(0).getKey(), (String)"baz");
        Assert.assertEquals((Object)pluginProperties.get(0).getValue(), (Object)12L);
        Assert.assertFalse((boolean)pluginProperties.get(0).getIsUpdatable());
        Assert.assertEquals((String)pluginProperties.get(1).getKey(), (String)"baz2");
        Assert.assertEquals((Object)pluginProperties.get(1).getValue(), (Object)"something else");
        Assert.assertFalse((boolean)pluginProperties.get(1).getIsUpdatable());
        Assert.assertEquals((String)pluginProperties.get(2).getKey(), (String)"foo");
        Assert.assertEquals((Object)pluginProperties.get(2).getValue(), (Object)"override");
        Assert.assertFalse((boolean)pluginProperties.get(2).getIsUpdatable());
    }

    @Test(groups={"fast"})
    public void testToMap() throws Exception {
        Map properties = PluginProperties.toMap((Iterable[])new Iterable[]{this.pluginProperties1, this.pluginProperties2});
        Assert.assertEquals(properties.get("baz"), (Object)12L);
        Assert.assertEquals(properties.get("baz2"), (Object)"something else");
        Assert.assertEquals(properties.get("foo"), (Object)"override");
    }

    @Test(groups={"fast"})
    public void testBuildPluginProperties() throws Exception {
        Assert.assertEquals((int)this.pluginProperties1.size(), (int)2);
        Assert.assertEquals((String)this.pluginProperties1.get(0).getKey(), (String)"foo");
        Assert.assertEquals((Object)this.pluginProperties1.get(0).getValue(), (Object)"bar");
        Assert.assertFalse((boolean)this.pluginProperties1.get(0).getIsUpdatable());
        Assert.assertEquals((String)this.pluginProperties1.get(1).getKey(), (String)"baz");
        Assert.assertEquals((Object)this.pluginProperties1.get(1).getValue(), (Object)12L);
        Assert.assertFalse((boolean)this.pluginProperties1.get(1).getIsUpdatable());
    }

    private List<PluginProperty> sort(Iterable<PluginProperty> pluginProperties) {
        return Ordering.natural().onResultOf((Function)new Function<PluginProperty, String>(){

            public String apply(PluginProperty pluginProperty) {
                return pluginProperty.getKey();
            }
        }).immutableSortedCopy(pluginProperties);
    }
}

