/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import javax.inject.Inject;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.util.ThreadContext;
import org.killbill.billing.GuicyKillbillTestSuiteNoDB;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.account.api.ImmutableAccountInternalApi;
import org.killbill.billing.security.Permission;
import org.killbill.billing.security.api.SecurityApi;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.audit.dao.AuditDao;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.glue.TestUtilModuleNoDB;
import org.killbill.billing.util.security.shiro.realm.KillBillJndiLdapRealm;
import org.killbill.bus.api.PersistentBus;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public class UtilTestSuiteNoDB
extends GuicyKillbillTestSuiteNoDB {
    @Inject
    protected PersistentBus eventBus;
    @Inject
    protected CacheControllerDispatcher controlCacheDispatcher;
    @Inject
    protected NonEntityDao nonEntityDao;
    @Inject
    protected InternalCallContextFactory internalCallContextFactory;
    @Inject
    protected CacheControllerDispatcher cacheControllerDispatcher;
    @Inject
    protected AuditDao auditDao;
    @Inject
    protected AuditUserApi auditUserApi;
    @Inject
    protected SecurityApi securityApi;
    @Inject
    protected KillBillJndiLdapRealm killBillJndiLdapRealm;
    @Inject
    protected AccountUserApi accountUserApi;
    @Inject
    protected AccountInternalApi accountInternalApi;
    @Inject
    protected ImmutableAccountInternalApi immutableAccountInternalApi;

    @BeforeClass(groups={"fast"})
    public void beforeClass() throws Exception {
        Injector g = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new TestUtilModuleNoDB(this.configSource)});
        g.injectMembers((Object)this);
    }

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() throws Exception {
        this.eventBus.start();
    }

    @AfterMethod(groups={"fast"})
    public void afterMethod() throws Exception {
        this.eventBus.stop();
        ThreadContext.unbindSecurityManager();
    }

    protected void login(String username) {
        this.securityApi.login((Object)username, (Object)"password");
    }

    protected void logout() {
        this.securityApi.logout();
    }

    protected void configureShiro() {
        Ini config = new Ini();
        config.addSection("users");
        config.getSection("users").put("pierre", "password, creditor");
        config.getSection("users").put("stephane", "password, refunder");
        config.addSection("roles");
        config.getSection("roles").put("creditor", Permission.INVOICE_CAN_CREDIT.toString() + "," + Permission.INVOICE_CAN_ITEM_ADJUST.toString());
        config.getSection("roles").put("refunder", Permission.PAYMENT_CAN_REFUND.toString());
        ThreadContext.unbindSecurityManager();
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory(config);
        SecurityManager securityManager = (SecurityManager)factory.getInstance();
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
    }
}

