/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import javax.inject.Inject;
import org.killbill.billing.GuicyKillbillTestSuiteWithEmbeddedDB;
import org.killbill.billing.account.api.ImmutableAccountInternalApi;
import org.killbill.billing.api.TestApiListener;
import org.killbill.billing.security.api.SecurityApi;
import org.killbill.billing.util.audit.dao.AuditDao;
import org.killbill.billing.util.broadcast.dao.BroadcastDao;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.config.definition.SecurityConfig;
import org.killbill.billing.util.customfield.api.DefaultCustomFieldUserApi;
import org.killbill.billing.util.customfield.dao.CustomFieldDao;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.export.dao.DatabaseExportDao;
import org.killbill.billing.util.glue.TestUtilModuleWithEmbeddedDB;
import org.killbill.billing.util.nodes.dao.NodeInfoDao;
import org.killbill.billing.util.tag.api.DefaultTagUserApi;
import org.killbill.billing.util.tag.dao.DefaultTagDao;
import org.killbill.billing.util.tag.dao.TagDefinitionDao;
import org.killbill.bus.api.PersistentBus;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.locker.GlobalLocker;
import org.killbill.commons.locker.memory.MemoryGlobalLocker;
import org.killbill.commons.locker.mysql.MySqlGlobalLocker;
import org.killbill.commons.locker.postgresql.PostgreSQLGlobalLocker;
import org.killbill.notificationq.api.NotificationQueueService;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class UtilTestSuiteWithEmbeddedDB
extends GuicyKillbillTestSuiteWithEmbeddedDB {
    private static final Logger log = LoggerFactory.getLogger(UtilTestSuiteWithEmbeddedDB.class);
    @Inject
    protected PersistentBus eventBus;
    @Inject
    protected NonEntityDao nonEntityDao;
    @Inject
    protected InternalCallContextFactory internalCallContextFactory;
    @Inject
    protected ImmutableAccountInternalApi immutableAccountInternalApi;
    @Inject
    protected DefaultTagUserApi tagUserApi;
    @Inject
    protected DefaultCustomFieldUserApi customFieldUserApi;
    @Inject
    protected CustomFieldDao customFieldDao;
    @Inject
    protected DatabaseExportDao dao;
    @Inject
    protected NotificationQueueService queueService;
    @Inject
    protected TagDefinitionDao tagDefinitionDao;
    @Inject
    protected DefaultTagDao tagDao;
    @Inject
    protected AuditDao auditDao;
    @Inject
    protected GlobalLocker locker;
    @Inject
    protected IDBI idbi;
    @Inject
    protected TestApiListener eventsListener;
    @Inject
    protected SecurityApi securityApi;
    @Inject
    protected SecurityConfig securityConfig;
    @Inject
    protected NodeInfoDao nodeInfoDao;
    @Inject
    protected BroadcastDao broadcastDao;

    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        Injector g = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new TestUtilModuleWithEmbeddedDB(this.configSource)});
        g.injectMembers((Object)this);
        if (EmbeddedDB.DBEngine.MYSQL.equals((Object)this.helper.getDBEngine())) {
            Assert.assertTrue((boolean)(this.locker instanceof MySqlGlobalLocker));
        } else if (EmbeddedDB.DBEngine.POSTGRESQL.equals((Object)this.helper.getDBEngine())) {
            Assert.assertTrue((boolean)(this.locker instanceof PostgreSQLGlobalLocker));
        } else {
            Assert.assertTrue((boolean)(this.locker instanceof MemoryGlobalLocker));
        }
        Assert.assertTrue((boolean)this.locker.isFree("a", "b"));
    }

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        this.eventsListener.reset();
        this.eventBus.start();
        this.eventBus.register((Object)this.eventsListener);
    }

    @AfterMethod(groups={"slow"})
    public void afterMethod() throws Exception {
        this.eventBus.unregister((Object)this.eventsListener);
        this.eventBus.stop();
    }

    protected void assertListenerStatus() {
        this.eventsListener.assertListenerStatus();
    }
}

