/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.audit;

import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.DefaultCallContext;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.audit.DefaultAuditLog;
import org.killbill.billing.util.audit.dao.AuditLogModelDao;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.CallOrigin;
import org.killbill.billing.util.callcontext.UserType;
import org.killbill.billing.util.dao.EntityAudit;
import org.killbill.billing.util.dao.TableName;
import org.killbill.clock.Clock;
import org.killbill.clock.ClockMock;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultAuditLog
extends UtilTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testGetters() throws Exception {
        TableName tableName = TableName.ACCOUNT_EMAIL_HISTORY;
        long recordId = Long.MAX_VALUE;
        ChangeType changeType = ChangeType.DELETE;
        EntityAudit entityAudit = new EntityAudit(tableName, Long.valueOf(Long.MAX_VALUE), changeType, null);
        UUID tenantId = UUID.randomUUID();
        String userName = UUID.randomUUID().toString();
        CallOrigin callOrigin = CallOrigin.EXTERNAL;
        UserType userType = UserType.CUSTOMER;
        UUID userToken = UUID.randomUUID();
        ClockMock clock = new ClockMock();
        DefaultCallContext callContext = new DefaultCallContext(tenantId, userName, callOrigin, userType, userToken, (Clock)clock);
        DefaultAuditLog auditLog = new DefaultAuditLog(new AuditLogModelDao(entityAudit, (CallContext)callContext), ObjectType.ACCOUNT_EMAIL, UUID.randomUUID());
        Assert.assertEquals((Object)auditLog.getChangeType(), (Object)changeType);
        Assert.assertNull((Object)auditLog.getComment());
        Assert.assertNotNull((Object)auditLog.getCreatedDate());
        Assert.assertNull((Object)auditLog.getReasonCode());
        Assert.assertEquals((String)auditLog.getUserName(), (String)userName);
        Assert.assertEquals((String)auditLog.getUserToken(), (String)userToken.toString());
    }

    @Test(groups={"fast"})
    public void testEquals() throws Exception {
        TableName tableName = TableName.ACCOUNT_EMAIL_HISTORY;
        long recordId = Long.MAX_VALUE;
        ChangeType changeType = ChangeType.DELETE;
        EntityAudit entityAudit = new EntityAudit(tableName, Long.valueOf(Long.MAX_VALUE), changeType, null);
        UUID tenantId = UUID.randomUUID();
        String userName = UUID.randomUUID().toString();
        CallOrigin callOrigin = CallOrigin.EXTERNAL;
        UserType userType = UserType.CUSTOMER;
        UUID userToken = UUID.randomUUID();
        ClockMock clock = new ClockMock();
        DefaultCallContext callContext = new DefaultCallContext(tenantId, userName, callOrigin, userType, userToken, (Clock)clock);
        AuditLogModelDao auditLog = new AuditLogModelDao(entityAudit, (CallContext)callContext);
        Assert.assertEquals((Object)auditLog, (Object)auditLog);
        AuditLogModelDao sameAuditLog = new AuditLogModelDao(entityAudit, (CallContext)callContext);
        Assert.assertEquals((Object)sameAuditLog, (Object)auditLog);
        clock.addMonths(1);
        DefaultCallContext otherCallContext = new DefaultCallContext(tenantId, userName, callOrigin, userType, userToken, (Clock)clock);
        AuditLogModelDao otherAuditLog = new AuditLogModelDao(entityAudit, (CallContext)otherCallContext);
        Assert.assertNotEquals((Object)otherAuditLog, (Object)auditLog);
    }
}

