/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.audit.api;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.AuditLogsTestBase;
import org.killbill.billing.util.audit.dao.MockAuditDao;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.dao.TableName;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDefaultAuditUserApi
extends AuditLogsTestBase {
    private List<AuditLog> auditLogs;
    private List<UUID> objectIds;

    @BeforeClass(groups={"fast"})
    public void beforeClass() throws Exception {
        super.beforeClass();
        this.auditLogs = ImmutableList.of((Object)this.createAuditLog(), (Object)this.createAuditLog(), (Object)this.createAuditLog(), (Object)this.createAuditLog());
        this.objectIds = ImmutableList.of((Object)UUID.randomUUID(), (Object)UUID.randomUUID(), (Object)UUID.randomUUID(), (Object)UUID.randomUUID());
        for (TableName tableName : TableName.values()) {
            for (UUID objectId : this.objectIds) {
                for (AuditLog auditLog : this.auditLogs) {
                    ((MockAuditDao)this.auditDao).addAuditLogForId(tableName, objectId, auditLog);
                }
            }
        }
    }

    @Test(groups={"fast"})
    public void testForObject() throws Exception {
        for (ObjectType objectType : ObjectType.values()) {
            for (UUID objectId : this.objectIds) {
                for (AuditLevel level : AuditLevel.values()) {
                    if (AuditLevel.NONE.equals((Object)level)) {
                        Assert.assertEquals((int)this.auditUserApi.getAuditLogs(objectId, objectType, level, (TenantContext)this.callContext).size(), (int)0);
                        continue;
                    }
                    if (AuditLevel.MINIMAL.equals((Object)level)) {
                        Assert.assertEquals((Collection)this.auditUserApi.getAuditLogs(objectId, objectType, level, (TenantContext)this.callContext), (Collection)ImmutableList.of((Object)this.auditLogs.get(0)));
                        continue;
                    }
                    Assert.assertEquals((Collection)this.auditUserApi.getAuditLogs(objectId, objectType, level, (TenantContext)this.callContext), this.auditLogs);
                }
            }
        }
    }
}

