/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.audit.dao;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.DefaultAccountAuditLogs;
import org.killbill.billing.util.audit.DefaultAccountAuditLogsForObjectType;
import org.killbill.billing.util.audit.dao.AuditDao;
import org.killbill.billing.util.dao.TableName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockAuditDao
implements AuditDao {
    private final Map<TableName, Map<UUID, List<AuditLog>>> auditLogsForTables = new HashMap<TableName, Map<UUID, List<AuditLog>>>();

    public synchronized void addAuditLogForId(TableName tableName, UUID objectId, AuditLog auditLog) {
        this.addAuditLogsForId(tableName, objectId, (List<AuditLog>)ImmutableList.of((Object)auditLog));
    }

    public synchronized void addAuditLogsForId(TableName tableName, UUID objectId, List<AuditLog> auditLogs) {
        if (this.auditLogsForTables.get(tableName) == null) {
            this.auditLogsForTables.put(tableName, new HashMap());
        }
        if (this.auditLogsForTables.get(tableName).get(objectId) == null) {
            this.auditLogsForTables.get(tableName).put(objectId, new ArrayList());
        }
        this.auditLogsForTables.get(tableName).get(objectId).addAll(auditLogs);
    }

    public DefaultAccountAuditLogs getAuditLogsForAccountRecordId(AuditLevel auditLevel, InternalTenantContext context) {
        throw new UnsupportedOperationException();
    }

    public DefaultAccountAuditLogsForObjectType getAuditLogsForAccountRecordId(TableName tableName, AuditLevel auditLevel, InternalTenantContext context) {
        throw new UnsupportedOperationException();
    }

    public List<AuditLog> getAuditLogsForId(TableName tableName, UUID objectId, AuditLevel auditLevel, InternalTenantContext context) {
        Map<UUID, List<AuditLog>> auditLogsForTableName = this.auditLogsForTables.get(tableName);
        if (auditLogsForTableName == null) {
            return ImmutableList.of();
        }
        List<AuditLog> auditLogsForObjectId = auditLogsForTableName.get(objectId);
        List allAuditLogs = (List)MoreObjects.firstNonNull(auditLogsForObjectId, (Object)ImmutableList.of());
        if (AuditLevel.FULL.equals((Object)auditLevel)) {
            return allAuditLogs;
        }
        if (AuditLevel.MINIMAL.equals((Object)auditLevel) && allAuditLogs.size() > 0) {
            return ImmutableList.of(allAuditLogs.get(0));
        }
        if (AuditLevel.NONE.equals((Object)auditLevel)) {
            return ImmutableList.of();
        }
        return allAuditLogs;
    }
}

