/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.audit.dao;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.api.TestApiListener;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.audit.DefaultAccountAuditLogs;
import org.killbill.billing.util.audit.DefaultAccountAuditLogsForObjectType;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.tag.DescriptiveTag;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;
import org.killbill.billing.util.tag.dao.TagModelDao;
import org.skife.jdbi.v2.Handle;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDefaultAuditDao
extends UtilTestSuiteWithEmbeddedDB {
    private TagModelDao tag;

    @Test(groups={"slow"})
    public void testRetrieveAuditsDirectly() throws Exception {
        this.addTag();
        Handle handle = this.dbi.open();
        String tagHistoryString = (String)((Map)handle.select("select id from tag_history limit 1", new Object[0]).get(0)).get("id");
        handle.close();
        for (AuditLevel level : AuditLevel.values()) {
            List auditLogs = this.auditDao.getAuditLogsForId(TableName.TAG_HISTORY, UUID.fromString(tagHistoryString), level, (InternalTenantContext)this.internalCallContext);
            this.verifyAuditLogsForTag(auditLogs, level);
        }
    }

    @Test(groups={"slow"})
    public void testRetrieveAuditsViaHistory() throws Exception {
        this.addTag();
        for (AuditLevel level : AuditLevel.values()) {
            List auditLogs = this.auditDao.getAuditLogsForId(TableName.TAG, this.tag.getId(), level, (InternalTenantContext)this.internalCallContext);
            this.verifyAuditLogsForTag(auditLogs, level);
            DefaultAccountAuditLogs accountAuditLogs = this.auditDao.getAuditLogsForAccountRecordId(level, (InternalTenantContext)this.internalCallContext);
            this.verifyAuditLogsForTag(accountAuditLogs.getAuditLogs(ObjectType.TAG).getAuditLogs(this.tag.getId()), level);
            DefaultAccountAuditLogsForObjectType accountAuditLogsForObjectType = this.auditDao.getAuditLogsForAccountRecordId(TableName.TAG, level, (InternalTenantContext)this.internalCallContext);
            this.verifyAuditLogsForTag(accountAuditLogsForObjectType.getAuditLogs(this.tag.getId()), level);
        }
    }

    @Test(groups={"slow"})
    public void testVerifyAuditCachesAreCleared() throws Exception {
        this.addTag();
        List firstAuditLogs = this.auditDao.getAuditLogsForId(TableName.TAG, this.tag.getId(), AuditLevel.FULL, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)firstAuditLogs.size(), (int)1);
        Assert.assertEquals((Object)((AuditLog)firstAuditLogs.get(0)).getChangeType(), (Object)ChangeType.INSERT);
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        this.tagDao.deleteTag(this.tag.getObjectId(), this.tag.getObjectType(), this.tag.getTagDefinitionId(), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        List secondAuditLogs = this.auditDao.getAuditLogsForId(TableName.TAG, this.tag.getId(), AuditLevel.FULL, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)secondAuditLogs.size(), (int)2);
        Assert.assertEquals((Object)((AuditLog)secondAuditLogs.get(0)).getChangeType(), (Object)ChangeType.INSERT);
        Assert.assertEquals((Object)((AuditLog)secondAuditLogs.get(1)).getChangeType(), (Object)ChangeType.DELETE);
    }

    private void addTag() throws TagDefinitionApiException, TagApiException {
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        TagDefinitionModelDao tagDefinition = this.tagDefinitionDao.create(UUID.randomUUID().toString().substring(0, 5), UUID.randomUUID().toString().substring(0, 5), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        Assert.assertEquals((Object)this.tagDefinitionDao.getById(tagDefinition.getId(), (InternalTenantContext)this.internalCallContext), (Object)tagDefinition);
        UUID objectId = UUID.randomUUID();
        DescriptiveTag theTag = new DescriptiveTag(tagDefinition.getId(), ObjectType.ACCOUNT, objectId, this.clock.getUTCNow());
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        this.tagDao.create(new TagModelDao((Tag)theTag), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        List tags = this.tagDao.getTagsForObject(objectId, ObjectType.ACCOUNT, false, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)tags.size(), (int)1);
        this.tag = (TagModelDao)tags.get(0);
        Assert.assertEquals((Object)this.tag.getTagDefinitionId(), (Object)tagDefinition.getId());
    }

    private void verifyAuditLogsForTag(List<AuditLog> auditLogs, AuditLevel level) {
        if (AuditLevel.NONE.equals((Object)level)) {
            Assert.assertEquals((int)auditLogs.size(), (int)0);
            return;
        }
        Assert.assertEquals((int)auditLogs.size(), (int)1);
        Assert.assertEquals((String)auditLogs.get(0).getUserToken(), (String)this.internalCallContext.getUserToken().toString());
        Assert.assertEquals((Object)auditLogs.get(0).getChangeType(), (Object)ChangeType.INSERT);
        Assert.assertEquals((String)auditLogs.get(0).getComment(), (String)this.internalCallContext.getComments());
        Assert.assertEquals((String)auditLogs.get(0).getReasonCode(), (String)this.internalCallContext.getReasonCode());
        Assert.assertEquals((String)auditLogs.get(0).getUserName(), (String)this.internalCallContext.getCreatedBy());
        Assert.assertNotNull((Object)auditLogs.get(0).getCreatedDate());
    }
}

