/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.bcd;

import java.util.HashMap;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.GuicyKillbillTestSuiteNoDB;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.Catalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.mock.MockAccountBuilder;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.user.SubscriptionBaseBundle;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.bcd.BillCycleDayCalculator;
import org.killbill.clock.Clock;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBillCycleDayCalculator
extends UtilTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testCalculateBCDForAOWithBPCancelledBundleAligned() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.UTC;
        DateTime bpStartDateUTC = new DateTime(2012, 7, 16, 21, 0, 0, DateTimeZone.UTC);
        int expectedBCDUTC = 16;
        SubscriptionBaseBundle bundle = (SubscriptionBaseBundle)Mockito.mock(SubscriptionBaseBundle.class);
        SubscriptionBase subscription = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        Mockito.when((Object)subscription.getStartDate()).thenReturn((Object)bpStartDateUTC);
        Plan plan = (Plan)Mockito.mock(Plan.class);
        Catalog catalog = (Catalog)Mockito.mock(Catalog.class);
        Mockito.when((Object)catalog.findPlan(Mockito.anyString(), (DateTime)Mockito.any(), (DateTime)Mockito.any())).thenReturn((Object)plan);
        Mockito.when((Object)subscription.getLastActivePlan()).thenReturn((Object)plan);
        Mockito.when((Object)subscription.getDateOfFirstRecurringNonZeroCharge()).thenReturn((Object)bpStartDateUTC);
        ImmutableAccountData account = (ImmutableAccountData)Mockito.mock(ImmutableAccountData.class);
        Mockito.when((Object)account.getTimeZone()).thenReturn((Object)accountTimeZone);
        Integer billCycleDayLocal = BillCycleDayCalculator.calculateBcdForAlignment(new HashMap(), (SubscriptionBase)subscription, (SubscriptionBase)subscription, (BillingAlignment)BillingAlignment.BUNDLE, (InternalTenantContext)this.internalCallContext, (int)0);
        Assert.assertEquals((Object)billCycleDayLocal, (Object)16);
    }

    @Test(groups={"fast"})
    public void testCalculateBCDWithTimeZoneHST() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.forID((String)"HST");
        DateTime startDateUTC = new DateTime((Object)"2012-07-16T21:17:03.000Z", DateTimeZone.UTC);
        int bcdLocal = 16;
        this.createAccountAndRefreshTimeAwareContext(accountTimeZone, startDateUTC);
        this.verifyBCDCalculation(accountTimeZone, startDateUTC, 16);
    }

    @Test(groups={"fast"})
    public void testCalculateBCDWithTimeZoneCEST() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.forID((String)"Europe/Paris");
        DateTime startDateUTC = new DateTime((Object)"2012-07-16T21:17:03.000Z", DateTimeZone.UTC);
        int bcdLocal = 16;
        this.createAccountAndRefreshTimeAwareContext(accountTimeZone, startDateUTC);
        this.verifyBCDCalculation(accountTimeZone, startDateUTC, 16);
    }

    @Test(groups={"fast"})
    public void testCalculateBCDWithTimeZoneUTC() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.UTC;
        DateTime startDateUTC = new DateTime((Object)"2012-07-16T21:17:03.000Z", DateTimeZone.UTC);
        int bcdLocal = 16;
        this.createAccountAndRefreshTimeAwareContext(accountTimeZone, startDateUTC);
        this.verifyBCDCalculation(accountTimeZone, startDateUTC, 16);
    }

    @Test(groups={"fast"})
    public void testCalculateBCDWithTimeZoneEEST() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.forID((String)"+0300");
        DateTime startDateUTC = new DateTime((Object)"2012-07-16T21:17:03.000Z", DateTimeZone.UTC);
        int bcdLocal = 17;
        this.createAccountAndRefreshTimeAwareContext(accountTimeZone, startDateUTC);
        this.verifyBCDCalculation(accountTimeZone, startDateUTC, 17);
    }

    @Test(groups={"fast"})
    public void testCalculateBCDWithTimeZoneJST() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.forID((String)"Asia/Tokyo");
        DateTime startDateUTC = new DateTime((Object)"2012-07-16T21:17:03.000Z", DateTimeZone.UTC);
        int bcdLocal = 17;
        this.createAccountAndRefreshTimeAwareContext(accountTimeZone, startDateUTC);
        this.verifyBCDCalculation(accountTimeZone, startDateUTC, 17);
    }

    @Test(groups={"fast"})
    public void testCalculateBCDWithSubscriptionDateNotInUTC() throws Exception {
        DateTimeZone accountTimeZone = DateTimeZone.forID((String)"Asia/Tokyo");
        DateTime startDate = new DateTime((Object)"2012-07-16T21:17:03.000Z", DateTimeZone.forID((String)"HST"));
        int bcdLocal = 17;
        this.createAccountAndRefreshTimeAwareContext(accountTimeZone, startDate);
        this.verifyBCDCalculation(accountTimeZone, startDate, 17);
    }

    private void verifyBCDCalculation(DateTimeZone accountTimeZone, DateTime startDateUTC, int bcdLocal) throws AccountApiException, CatalogApiException {
        SubscriptionBase subscription = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        Mockito.when((Object)subscription.getStartDate()).thenReturn((Object)startDateUTC);
        Mockito.when((Object)subscription.getDateOfFirstRecurringNonZeroCharge()).thenReturn((Object)startDateUTC);
        ImmutableAccountData account = (ImmutableAccountData)Mockito.mock(ImmutableAccountData.class);
        Mockito.when((Object)account.getTimeZone()).thenReturn((Object)accountTimeZone);
        Integer bcd = BillCycleDayCalculator.calculateBcdForAlignment(new HashMap(), (SubscriptionBase)subscription, (SubscriptionBase)subscription, (BillingAlignment)BillingAlignment.SUBSCRIPTION, (InternalTenantContext)this.internalCallContext, (int)0);
        Assert.assertEquals((Object)bcd, (Object)bcdLocal);
    }

    private void createAccountAndRefreshTimeAwareContext(DateTimeZone dateTimeZone, DateTime referenceDateTime) throws AccountApiException {
        Account accountData = new MockAccountBuilder().externalKey(UUID.randomUUID().toString()).timeZone(dateTimeZone).createdDate(referenceDateTime).build();
        GuicyKillbillTestSuiteNoDB.createMockAccount(accountData, this.accountUserApi, this.accountInternalApi, this.immutableAccountInternalApi, this.nonEntityDao, (Clock)this.clock, this.internalCallContextFactory, this.callContext, this.internalCallContext);
    }
}

