/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.broadcast;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import org.killbill.billing.api.TestApiListener;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.broadcast.BroadcastService;
import org.killbill.billing.util.broadcast.DefaultBroadcastService;
import org.killbill.billing.util.broadcast.dao.BroadcastModelDao;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestBroadcastService
extends UtilTestSuiteWithEmbeddedDB {
    @Inject
    private BroadcastService broadcastService;

    protected KillbillConfigSource getConfigSource() {
        return this.getConfigSource(null, (ImmutableMap<String, String>)ImmutableMap.of((Object)"org.killbill.billing.util.broadcast.rate", (Object)"500ms"));
    }

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        ((DefaultBroadcastService)this.broadcastService).initialize();
        ((DefaultBroadcastService)this.broadcastService).start();
    }

    @AfterMethod(groups={"slow"})
    public void afterMethod() throws Exception {
        ((DefaultBroadcastService)this.broadcastService).stop();
        super.afterMethod();
    }

    @Test(groups={"slow"})
    public void testBasic() {
        String eventJson = "\"{\"pluginName\":\"foo\",\"pluginVersion\":\"1.2.3\",\"properties\":[{\"key\":\"something\",\"value\":\"nothing\"}]}\"";
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.BROADCAST_SERVICE);
        this.broadcastDao.create(new BroadcastModelDao("svc", "type", "\"{\"pluginName\":\"foo\",\"pluginVersion\":\"1.2.3\",\"properties\":[{\"key\":\"something\",\"value\":\"nothing\"}]}\"", this.clock.getUTCNow(), "tester"));
        this.assertListenerStatus();
    }
}

