/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.broadcast;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import org.killbill.billing.events.BroadcastInternalEvent;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.broadcast.DefaultBroadcastInternalEvent;
import org.killbill.billing.util.jackson.ObjectMapper;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultBroadcastInternalEvent
extends UtilTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testBasic() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JodaModule());
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        String eventJson = "\"{\"pluginName\":\"foo\",\"pluginVersion\":\"1.2.3\",\"properties\":[{\"key\":\"something\",\"value\":\"nothing\"}]}\"";
        DefaultBroadcastInternalEvent broadcastEvent = new DefaultBroadcastInternalEvent("service", "PLUGIN_INSTALL", "\"{\"pluginName\":\"foo\",\"pluginVersion\":\"1.2.3\",\"properties\":[{\"key\":\"something\",\"value\":\"nothing\"}]}\"");
        String broadcastEventStr = objectMapper.writeValueAsString((Object)broadcastEvent);
        BroadcastInternalEvent res = (BroadcastInternalEvent)objectMapper.readValue(broadcastEventStr, DefaultBroadcastInternalEvent.class);
        Assert.assertEquals((String)res.getServiceName(), (String)"service");
        Assert.assertEquals((String)res.getType(), (String)"PLUGIN_INSTALL");
        Assert.assertEquals((String)res.getJsonEvent(), (String)"\"{\"pluginName\":\"foo\",\"pluginVersion\":\"1.2.3\",\"properties\":[{\"key\":\"something\",\"value\":\"nothing\"}]}\"");
    }
}

