/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.billing.util.tag.dao.TagModelDao;
import org.killbill.billing.util.tag.dao.TagSqlDao;
import org.killbill.clock.Clock;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCache
extends UtilTestSuiteWithEmbeddedDB {
    private EntitySqlDaoTransactionalJdbiWrapper transactionalSqlDao;

    private Long getTagRecordId(final UUID tagId) {
        return (Long)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Long>(){

            public Long inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return ((TagSqlDao)entitySqlDaoWrapperFactory.become(TagSqlDao.class)).getRecordId(tagId.toString(), (InternalTenantContext)TestCache.this.internalCallContext);
            }
        });
    }

    private int getCacheSize(Cachable.CacheType cacheType) {
        CacheController cache = this.controlCacheDispatcher.getCacheController(cacheType);
        return cache != null ? cache.size() : 0;
    }

    private Long retrieveRecordIdFromCache(UUID tagId) {
        CacheController cache = this.controlCacheDispatcher.getCacheController(Cachable.CacheType.RECORD_ID);
        Object result = null;
        if (cache != null) {
            result = cache.get((Object)tagId.toString().toUpperCase(), new CacheLoaderArgument(ObjectType.TAG));
        }
        return (Long)result;
    }

    @Test(groups={"slow"})
    public void testCacheRecordId() throws Exception {
        this.transactionalSqlDao = new EntitySqlDaoTransactionalJdbiWrapper(this.dbi, (Clock)this.clock, this.controlCacheDispatcher, this.nonEntityDao, this.internalCallContextFactory);
        TagModelDao tag = new TagModelDao(this.clock.getUTCNow(), UUID.randomUUID(), UUID.randomUUID(), ObjectType.TAG);
        Assert.assertEquals((int)this.getCacheSize(Cachable.CacheType.RECORD_ID), (int)0);
        this.insertTag(tag);
        Assert.assertEquals((int)this.getCacheSize(Cachable.CacheType.RECORD_ID), (int)0);
        Long tagRecordId = this.getTagRecordId(tag.getId());
        Assert.assertEquals((int)this.getCacheSize(Cachable.CacheType.RECORD_ID), (int)1);
        Long recordIdFromCache = this.retrieveRecordIdFromCache(tag.getId());
        Assert.assertNotNull((Object)recordIdFromCache);
        Assert.assertEquals((Object)recordIdFromCache, (Object)tagRecordId);
        Assert.assertTrue((recordIdFromCache > 0L ? 1 : 0) != 0);
        Assert.assertEquals((int)this.getCacheSize(Cachable.CacheType.RECORD_ID), (int)1);
    }

    @Test(groups={"slow"})
    public void testAllCachesAfterGetById() throws Exception {
        this.transactionalSqlDao = new EntitySqlDaoTransactionalJdbiWrapper(this.dbi, (Clock)this.clock, this.controlCacheDispatcher, this.nonEntityDao, this.internalCallContextFactory);
        TagModelDao tag = new TagModelDao(this.clock.getUTCNow(), UUID.randomUUID(), UUID.randomUUID(), ObjectType.TAG);
        this.insertTag(tag);
        Assert.assertEquals((int)this.getCacheSize(Cachable.CacheType.RECORD_ID), (int)0);
        Assert.assertEquals((int)this.getCacheSize(Cachable.CacheType.ACCOUNT_RECORD_ID), (int)0);
        Assert.assertEquals((int)this.getCacheSize(Cachable.CacheType.TENANT_RECORD_ID), (int)0);
        Assert.assertEquals((int)this.getCacheSize(Cachable.CacheType.OBJECT_ID), (int)0);
        TagModelDao result = this.getById(tag.getId());
        Assert.assertEquals((int)this.getCacheSize(Cachable.CacheType.RECORD_ID), (int)1);
        Assert.assertEquals((int)this.getCacheSize(Cachable.CacheType.ACCOUNT_RECORD_ID), (int)1);
        Assert.assertEquals((int)this.getCacheSize(Cachable.CacheType.TENANT_RECORD_ID), (int)1);
        Assert.assertEquals((int)this.getCacheSize(Cachable.CacheType.OBJECT_ID), (int)1);
        Long recordId = (Long)this.controlCacheDispatcher.getCacheController(Cachable.CacheType.RECORD_ID).get((Object)tag.getId().toString(), new CacheLoaderArgument(ObjectType.TAG));
        Assert.assertEquals((Object)recordId, (Object)result.getRecordId());
        Long tenantRecordId = (Long)this.controlCacheDispatcher.getCacheController(Cachable.CacheType.TENANT_RECORD_ID).get((Object)tag.getId().toString(), new CacheLoaderArgument(ObjectType.TAG));
        Assert.assertEquals((Object)tenantRecordId, (Object)result.getTenantRecordId());
        UUID objectId = (UUID)this.controlCacheDispatcher.getCacheController(Cachable.CacheType.OBJECT_ID).get((Object)(TableName.TAG + "::" + recordId), new CacheLoaderArgument(ObjectType.TAG));
        Assert.assertEquals((Object)objectId, (Object)result.getId());
        Long accountRecordId = (Long)this.controlCacheDispatcher.getCacheController(Cachable.CacheType.ACCOUNT_RECORD_ID).get((Object)tag.getId().toString(), new CacheLoaderArgument(ObjectType.TAG));
        Assert.assertEquals((Object)accountRecordId, (Object)result.getAccountRecordId());
    }

    private void insertTag(final TagModelDao modelDao) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                ((TagSqlDao)entitySqlDaoWrapperFactory.become(TagSqlDao.class)).create((EntityModelDao)modelDao, (InternalCallContext)TestCache.this.internalCallContext);
                return null;
            }
        });
    }

    private TagModelDao getById(final UUID id) {
        return (TagModelDao)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<TagModelDao>(){

            public TagModelDao inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return (TagModelDao)((TagSqlDao)entitySqlDaoWrapperFactory.become(TagSqlDao.class)).getById(id.toString(), (InternalTenantContext)TestCache.this.internalCallContext);
            }
        });
    }
}

