/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.callcontext;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.CallOrigin;
import org.killbill.billing.util.callcontext.UserType;
import org.killbill.clock.DefaultClock;

public class TestCallContext
implements CallContext {
    private final String userName;
    private final DateTime updatedDate;
    private final DateTime createdDate;
    private final UUID userToken;
    private final UUID tenantId;

    public TestCallContext(String userName) {
        this(userName, new DefaultClock().getUTCNow(), new DefaultClock().getUTCNow());
    }

    public TestCallContext(CallContext context, DateTime utcNow) {
        this.userName = context.getUserName();
        this.createdDate = utcNow;
        this.updatedDate = utcNow;
        this.userToken = context.getUserToken();
        this.tenantId = context.getTenantId();
    }

    public TestCallContext(String userName, DateTime createdDate, DateTime updatedDate) {
        this.userName = userName;
        this.createdDate = createdDate;
        this.updatedDate = updatedDate;
        this.userToken = UUID.randomUUID();
        this.tenantId = UUID.randomUUID();
    }

    public String getUserName() {
        return this.userName;
    }

    public CallOrigin getCallOrigin() {
        return CallOrigin.TEST;
    }

    public UserType getUserType() {
        return UserType.TEST;
    }

    public String getReasonCode() {
        return null;
    }

    public String getComments() {
        return null;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public UUID getUserToken() {
        return this.userToken;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }
}

