/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.callcontext;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.callcontext.DefaultCallContext;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultCallContext
extends UtilTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testGetters() throws Exception {
        UUID tenantId = UUID.randomUUID();
        String userName = UUID.randomUUID().toString();
        DateTime createdDate = this.clock.getUTCNow();
        String reasonCode = UUID.randomUUID().toString();
        String comment = UUID.randomUUID().toString();
        UUID userToken = UUID.randomUUID();
        DefaultCallContext callContext = new DefaultCallContext(tenantId, userName, createdDate, reasonCode, comment, userToken);
        Assert.assertEquals((Object)callContext.getTenantId(), (Object)tenantId);
        Assert.assertEquals((Object)callContext.getCreatedDate(), (Object)createdDate);
        Assert.assertNull((Object)callContext.getCallOrigin());
        Assert.assertEquals((String)callContext.getComments(), (String)comment);
        Assert.assertEquals((String)callContext.getReasonCode(), (String)reasonCode);
        Assert.assertEquals((String)callContext.getUserName(), (String)userName);
        Assert.assertEquals((Object)callContext.getUpdatedDate(), (Object)createdDate);
        Assert.assertEquals((Object)callContext.getUserToken(), (Object)userToken);
        Assert.assertNull((Object)callContext.getUserType());
    }

    @Test(groups={"fast"})
    public void testEquals() throws Exception {
        UUID tenantId = UUID.randomUUID();
        String userName = UUID.randomUUID().toString();
        DateTime createdDate = this.clock.getUTCNow();
        String reasonCode = UUID.randomUUID().toString();
        String comment = UUID.randomUUID().toString();
        UUID userToken = UUID.randomUUID();
        DefaultCallContext callContext = new DefaultCallContext(tenantId, userName, createdDate, reasonCode, comment, userToken);
        Assert.assertEquals((Object)callContext, (Object)callContext);
        DefaultCallContext sameCallContext = new DefaultCallContext(tenantId, userName, createdDate, reasonCode, comment, userToken);
        Assert.assertEquals((Object)sameCallContext, (Object)callContext);
        DefaultCallContext otherCallContext = new DefaultCallContext(tenantId, UUID.randomUUID().toString(), createdDate, reasonCode, comment, userToken);
        Assert.assertNotEquals((Object)otherCallContext, (Object)callContext);
    }
}

