/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.callcontext;

import java.util.Date;
import java.util.UUID;
import org.joda.time.ReadableInstant;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.mockito.Mockito;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInternalCallContextFactory
extends UtilTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testCreateInternalCallContextWithAccountRecordIdFromSimpleObjectType() throws Exception {
        final UUID invoiceId = UUID.randomUUID();
        final Long accountRecordId = 19384012L;
        ImmutableAccountData immutableAccountData = (ImmutableAccountData)Mockito.mock(ImmutableAccountData.class);
        Mockito.when((Object)this.immutableAccountInternalApi.getImmutableAccountDataByRecordId((Long)Mockito.eq((Object)accountRecordId), (InternalTenantContext)Mockito.any())).thenReturn((Object)immutableAccountData);
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.execute("DROP TABLE IF EXISTS invoices;\nCREATE TABLE invoices (\n    record_id serial unique,\n    id varchar(36) NOT NULL,\n    account_id varchar(36) NOT NULL,\n    invoice_date date NOT NULL,\n    target_date date,\n    currency varchar(3) NOT NULL,\n    status varchar(15) NOT NULL DEFAULT 'COMMITTED',\n    migrated bool NOT NULL,\n    parent_invoice bool NOT NULL DEFAULT FALSE,\n    created_by varchar(50) NOT NULL,\n    created_date datetime NOT NULL,\n    account_record_id bigint /*! unsigned */ not null,\n    tenant_record_id bigint /*! unsigned */ not null default 0,\n    PRIMARY KEY(record_id)\n);", new Object[0]);
                handle.execute("insert into invoices (id, account_id, invoice_date, target_date, currency, migrated, created_by, created_date, account_record_id) values (?, ?, now(), now(), 'USD', false, 'test', now(), ?)", new Object[]{invoiceId.toString(), UUID.randomUUID().toString(), accountRecordId});
                return null;
            }
        });
        InternalCallContext context = this.internalCallContextFactory.createInternalCallContext(invoiceId, ObjectType.INVOICE, this.callContext);
        Assert.assertEquals((Object)context.getAccountRecordId(), (Object)accountRecordId);
        this.verifyInternalCallContext(context);
    }

    @Test(groups={"slow"})
    public void testCreateInternalCallContextWithAccountRecordIdFromAccountObjectType() throws Exception {
        final UUID accountId = UUID.randomUUID();
        final Long accountRecordId = 19384012L;
        ImmutableAccountData immutableAccountData = (ImmutableAccountData)Mockito.mock(ImmutableAccountData.class);
        Mockito.when((Object)this.immutableAccountInternalApi.getImmutableAccountDataByRecordId((Long)Mockito.eq((Object)accountRecordId), (InternalTenantContext)Mockito.any())).thenReturn((Object)immutableAccountData);
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.execute("insert into accounts (record_id, id, email, name, first_name_length, time_zone, is_notified_for_invoices, created_date, created_by, updated_date, updated_by) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{accountRecordId, accountId.toString(), "yo@t.com", "toto", 4, "UTC", false, new Date(), "i", new Date(), "j"});
                return null;
            }
        });
        InternalCallContext context = this.internalCallContextFactory.createInternalCallContext(accountId, ObjectType.ACCOUNT, this.callContext);
        Assert.assertEquals((Object)context.getAccountRecordId(), (Object)accountRecordId);
        this.verifyInternalCallContext(context);
    }

    private void verifyInternalCallContext(InternalCallContext context) {
        Assert.assertEquals((Object)context.getCallOrigin(), (Object)this.callContext.getCallOrigin());
        Assert.assertEquals((String)context.getComments(), (String)this.callContext.getComments());
        Assert.assertTrue((context.getCreatedDate().compareTo((ReadableInstant)this.callContext.getCreatedDate()) >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)context.getReasonCode(), (String)this.callContext.getReasonCode());
        Assert.assertTrue((context.getUpdatedDate().compareTo((ReadableInstant)this.callContext.getUpdatedDate()) >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)context.getCreatedBy(), (String)this.callContext.getUserName());
        Assert.assertEquals((Object)context.getUserToken(), (Object)this.callContext.getUserToken());
        Assert.assertEquals((Object)context.getContextUserType(), (Object)this.callContext.getUserType());
        Assert.assertEquals((Object)context.getTenantRecordId(), (Object)InternalCallContextFactory.INTERNAL_TENANT_RECORD_ID);
    }
}

