/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.callcontext;

import com.google.common.collect.ImmutableList;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.callcontext.TimeAwareContext;
import org.killbill.billing.mock.MockAccountBuilder;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.account.AccountDateTimeUtils;
import org.killbill.billing.util.entity.Entity;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTimeAwareContext
extends UtilTestSuiteNoDB {
    private final DateTimeFormatter DATE_TIME_FORMATTER = ISODateTimeFormat.dateTimeParser();
    private final String effectiveDateTime1 = "2012-01-20T07:30:42.000Z";
    private final String effectiveDateTime2 = "2012-01-20T08:00:00.000Z";
    private final String effectiveDateTime3 = "2012-01-20T08:45:33.000Z";
    private final String effectiveDateTimeA = "2012-01-20T16:30:42.000Z";
    private final String effectiveDateTimeB = "2012-01-20T16:00:00.000Z";
    private final String effectiveDateTimeC = "2012-01-20T15:30:42.000Z";

    @Test(groups={"fast"})
    public void testComputeUTCDateTimeFromLocalDate1() {
        DateTime effectiveDateTime = this.DATE_TIME_FORMATTER.parseDateTime("2012-01-20T07:30:42.000Z");
        DateTimeZone timeZone = DateTimeZone.forOffsetHours((int)-8);
        this.refreshCallContext(effectiveDateTime, timeZone);
        LocalDate endDate = new LocalDate(2013, 1, 19);
        DateTime endDateTimeInUTC = this.internalCallContext.toUTCDateTime(endDate);
        Assert.assertTrue((endDateTimeInUTC.compareTo((ReadableInstant)effectiveDateTime.plusYears(1)) == 0 ? 1 : 0) != 0);
    }

    @Test(groups={"fast"})
    public void testComputeUTCDateTimeFromLocalDate2() {
        DateTime effectiveDateTime = this.DATE_TIME_FORMATTER.parseDateTime("2012-01-20T08:00:00.000Z");
        DateTimeZone timeZone = DateTimeZone.forOffsetHours((int)-8);
        this.refreshCallContext(effectiveDateTime, timeZone);
        LocalDate endDate = new LocalDate(2013, 1, 20);
        DateTime endDateTimeInUTC = this.internalCallContext.toUTCDateTime(endDate);
        Assert.assertTrue((endDateTimeInUTC.compareTo((ReadableInstant)effectiveDateTime.plusYears(1)) == 0 ? 1 : 0) != 0);
    }

    @Test(groups={"fast"})
    public void testComputeUTCDateTimeFromLocalDate3() {
        DateTime effectiveDateTime = this.DATE_TIME_FORMATTER.parseDateTime("2012-01-20T08:45:33.000Z");
        DateTimeZone timeZone = DateTimeZone.forOffsetHours((int)-8);
        this.refreshCallContext(effectiveDateTime, timeZone);
        LocalDate endDate = new LocalDate(2013, 1, 20);
        DateTime endDateTimeInUTC = this.internalCallContext.toUTCDateTime(endDate);
        Assert.assertTrue((endDateTimeInUTC.compareTo((ReadableInstant)effectiveDateTime.plusYears(1)) == 0 ? 1 : 0) != 0);
    }

    @Test(groups={"fast"})
    public void testComputeUTCDateTimeFromLocalDateA() {
        DateTime effectiveDateTime = this.DATE_TIME_FORMATTER.parseDateTime("2012-01-20T16:30:42.000Z");
        DateTimeZone timeZone = DateTimeZone.forOffsetHours((int)8);
        this.refreshCallContext(effectiveDateTime, timeZone);
        LocalDate endDate = new LocalDate(2013, 1, 21);
        DateTime endDateTimeInUTC = this.internalCallContext.toUTCDateTime(endDate);
        Assert.assertTrue((endDateTimeInUTC.compareTo((ReadableInstant)effectiveDateTime.plusYears(1)) == 0 ? 1 : 0) != 0);
    }

    @Test(groups={"fast"})
    public void testComputeUTCDateTimeFromLocalDateB() {
        DateTime effectiveDateTime = this.DATE_TIME_FORMATTER.parseDateTime("2012-01-20T16:00:00.000Z");
        DateTimeZone timeZone = DateTimeZone.forOffsetHours((int)8);
        this.refreshCallContext(effectiveDateTime, timeZone);
        LocalDate endDate = new LocalDate(2013, 1, 21);
        DateTime endDateTimeInUTC = this.internalCallContext.toUTCDateTime(endDate);
        Assert.assertTrue((endDateTimeInUTC.compareTo((ReadableInstant)effectiveDateTime.plusYears(1)) == 0 ? 1 : 0) != 0);
    }

    @Test(groups={"fast"})
    public void testComputeUTCDateTimeFromLocalDateC() {
        DateTime effectiveDateTime = this.DATE_TIME_FORMATTER.parseDateTime("2012-01-20T15:30:42.000Z");
        DateTimeZone timeZone = DateTimeZone.forOffsetHours((int)8);
        this.refreshCallContext(effectiveDateTime, timeZone);
        LocalDate endDate = new LocalDate(2013, 1, 20);
        DateTime endDateTimeInUTC = this.internalCallContext.toUTCDateTime(endDate);
        Assert.assertTrue((endDateTimeInUTC.compareTo((ReadableInstant)effectiveDateTime.plusYears(1)) == 0 ? 1 : 0) != 0);
    }

    @Test(groups={"fast"})
    public void testComputeTargetDateWithDayLightSaving() {
        DateTime dateTime1 = new DateTime((Object)"2015-01-01T08:01:01.000Z");
        DateTime dateTime2 = new DateTime((Object)"2015-09-01T08:01:01.000Z");
        DateTime dateTime3 = new DateTime((Object)"2015-12-01T08:01:01.000Z");
        DateTimeZone timeZone = DateTimeZone.forID((String)"America/Juneau");
        DateTime referenceDateTimeWithDST = new DateTime((Object)"2015-09-01T08:01:01.000Z");
        this.refreshCallContext(referenceDateTimeWithDST, timeZone);
        Assert.assertEquals((Object)this.internalCallContext.toLocalDate(dateTime1), (Object)new LocalDate((Object)"2015-01-01"));
        Assert.assertEquals((Object)this.internalCallContext.toLocalDate(dateTime2), (Object)new LocalDate((Object)"2015-09-01"));
        Assert.assertEquals((Object)this.internalCallContext.toLocalDate(dateTime3), (Object)new LocalDate((Object)"2015-12-01"));
        DateTime referenceDateTimeWithoutDST = new DateTime((Object)"2015-02-01T08:01:01.000Z");
        this.refreshCallContext(referenceDateTimeWithoutDST, timeZone);
        Assert.assertEquals((Object)this.internalCallContext.toLocalDate(dateTime1), (Object)new LocalDate((Object)"2014-12-31"));
        Assert.assertEquals((Object)this.internalCallContext.toLocalDate(dateTime2), (Object)new LocalDate((Object)"2015-08-31"));
        Assert.assertEquals((Object)this.internalCallContext.toLocalDate(dateTime3), (Object)new LocalDate((Object)"2015-11-30"));
    }

    @Test(groups={"fast"})
    public void testIdempotencyOfDatesManipulation() throws Exception {
        ImmutableList.Builder dateTimeZoneBuilder = ImmutableList.builder();
        dateTimeZoneBuilder.add((Object)DateTimeZone.forID((String)"HST"));
        dateTimeZoneBuilder.add((Object)DateTimeZone.forID((String)"PST8PDT"));
        dateTimeZoneBuilder.add((Object)DateTimeZone.forID((String)"MST"));
        dateTimeZoneBuilder.add((Object)DateTimeZone.forID((String)"CST6CDT"));
        dateTimeZoneBuilder.add((Object)DateTimeZone.forID((String)"EST"));
        dateTimeZoneBuilder.add((Object)DateTimeZone.forID((String)"Brazil/DeNoronha"));
        dateTimeZoneBuilder.add((Object)DateTimeZone.forID((String)"UTC"));
        dateTimeZoneBuilder.add((Object)DateTimeZone.forID((String)"CET"));
        dateTimeZoneBuilder.add((Object)DateTimeZone.forID((String)"Europe/Istanbul"));
        dateTimeZoneBuilder.add((Object)DateTimeZone.forID((String)"Singapore"));
        dateTimeZoneBuilder.add((Object)DateTimeZone.forID((String)"Japan"));
        dateTimeZoneBuilder.add((Object)DateTimeZone.forID((String)"Australia/Sydney"));
        dateTimeZoneBuilder.add((Object)DateTimeZone.forID((String)"Pacific/Tongatapu"));
        ImmutableList dateTimeZones = dateTimeZoneBuilder.build();
        ImmutableList.Builder referenceDateTimeBuilder = ImmutableList.builder();
        referenceDateTimeBuilder.add((Object)new DateTime(2012, 1, 1, 1, 1, 1, DateTimeZone.UTC));
        referenceDateTimeBuilder.add((Object)new DateTime(2012, 3, 15, 12, 42, 0, DateTimeZone.forID((String)"PST8PDT")));
        referenceDateTimeBuilder.add((Object)new DateTime(2012, 11, 15, 12, 42, 0, DateTimeZone.forID((String)"PST8PDT")));
        ImmutableList referenceDateTimes = referenceDateTimeBuilder.build();
        DateTime currentDateTime = new DateTime(2015, 1, 1, 1, 1, DateTimeZone.UTC);
        DateTime endDateTime = new DateTime(2020, 1, 1, 1, 1, DateTimeZone.UTC);
        while (currentDateTime.compareTo((ReadableInstant)endDateTime) <= 0) {
            for (DateTimeZone dateTimeZone : dateTimeZones) {
                for (DateTime referenceDateTime : referenceDateTimes) {
                    TimeAwareContext timeAwareContext = new TimeAwareContext(dateTimeZone, referenceDateTime);
                    LocalDate computedLocalDate = timeAwareContext.toLocalDate(currentDateTime);
                    DateTime computedDateTime = timeAwareContext.toUTCDateTime(computedLocalDate);
                    LocalDate computedLocalDate2 = timeAwareContext.toLocalDate(computedDateTime);
                    String msg = String.format("currentDateTime=%s, localDate=%s, dateTime=%s, dateTimeZone=%s, referenceDateTime=%s", currentDateTime, computedLocalDate, computedDateTime, dateTimeZone, referenceDateTime);
                    Assert.assertEquals((Object)computedLocalDate2, (Object)computedLocalDate, (String)msg);
                }
            }
            currentDateTime = currentDateTime.plusHours(1);
        }
    }

    private void refreshCallContext(DateTime effectiveDateTime, DateTimeZone timeZone) {
        Account account = new MockAccountBuilder().timeZone(timeZone).createdDate(effectiveDateTime).build();
        this.internalCallContext.setFixedOffsetTimeZone(AccountDateTimeUtils.getFixedOffsetTimeZone((Account)account));
        this.internalCallContext.setReferenceTime(AccountDateTimeUtils.getReferenceDateTime((Entity)account));
    }
}

