/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.customfield.api;

import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.events.BusInternalEvent;
import org.killbill.billing.util.customfield.api.DefaultCustomFieldCreationEvent;
import org.killbill.billing.util.jackson.ObjectMapper;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultCustomFieldCreationEvent {
    @Test(groups={"fast"})
    public void testPojo() throws Exception {
        UUID customFieldId = UUID.randomUUID();
        UUID objectId = UUID.randomUUID();
        ObjectType objectType = ObjectType.ACCOUNT_EMAIL;
        DefaultCustomFieldCreationEvent event = new DefaultCustomFieldCreationEvent(customFieldId, objectId, objectType, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID());
        Assert.assertEquals((Object)event.getBusEventType(), (Object)BusInternalEvent.BusInternalEventType.CUSTOM_FIELD_CREATION);
        Assert.assertEquals((Object)event.getObjectId(), (Object)objectId);
        Assert.assertEquals((Object)event.getObjectType(), (Object)objectType);
        Assert.assertEquals((Object)event, (Object)event);
        Assert.assertEquals((Object)event, (Object)new DefaultCustomFieldCreationEvent(customFieldId, objectId, objectType, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID()));
    }

    @Test(groups={"fast"})
    public void testSerialization() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        UUID customFieldId = UUID.randomUUID();
        UUID objectId = UUID.randomUUID();
        ObjectType objectType = ObjectType.ACCOUNT_EMAIL;
        DefaultCustomFieldCreationEvent event = new DefaultCustomFieldCreationEvent(customFieldId, objectId, objectType, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID());
        String json = objectMapper.writeValueAsString((Object)event);
        DefaultCustomFieldCreationEvent fromJson = (DefaultCustomFieldCreationEvent)objectMapper.readValue(json, DefaultCustomFieldCreationEvent.class);
        Assert.assertEquals((Object)fromJson, (Object)event);
    }
}

