/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.customfield.api;

import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.events.BusInternalEvent;
import org.killbill.billing.util.customfield.api.DefaultCustomFieldDeletionEvent;
import org.killbill.billing.util.jackson.ObjectMapper;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultCustomFieldDeletionEvent {
    @Test(groups={"fast"})
    public void testPojo() throws Exception {
        UUID customFieldId = UUID.randomUUID();
        UUID objectId = UUID.randomUUID();
        ObjectType objectType = ObjectType.ACCOUNT_EMAIL;
        UUID userToken = UUID.randomUUID();
        DefaultCustomFieldDeletionEvent event = new DefaultCustomFieldDeletionEvent(customFieldId, objectId, objectType, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID());
        Assert.assertEquals((Object)event.getBusEventType(), (Object)BusInternalEvent.BusInternalEventType.CUSTOM_FIELD_DELETION);
        Assert.assertEquals((Object)event.getObjectId(), (Object)objectId);
        Assert.assertEquals((Object)event.getObjectType(), (Object)objectType);
        Assert.assertEquals((Object)event, (Object)event);
        Assert.assertEquals((Object)event, (Object)new DefaultCustomFieldDeletionEvent(customFieldId, objectId, objectType, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID()));
    }

    @Test(groups={"fast"})
    public void testSerialization() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        UUID customFieldId = UUID.randomUUID();
        UUID objectId = UUID.randomUUID();
        ObjectType objectType = ObjectType.ACCOUNT_EMAIL;
        UUID userToken = UUID.randomUUID();
        DefaultCustomFieldDeletionEvent event = new DefaultCustomFieldDeletionEvent(customFieldId, objectId, objectType, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID());
        String json = objectMapper.writeValueAsString((Object)event);
        DefaultCustomFieldDeletionEvent fromJson = (DefaultCustomFieldDeletionEvent)objectMapper.readValue(json, DefaultCustomFieldDeletionEvent.class);
        Assert.assertEquals((Object)fromJson, (Object)event);
    }
}

