/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.customfield.api;

import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.api.TestApiListener;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.customfield.StringCustomField;
import org.killbill.billing.util.entity.Pagination;
import org.mockito.Mockito;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultCustomFieldUserApi
extends UtilTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testSaveCustomFieldWithAccountRecordId() throws Exception {
        final UUID accountId = UUID.randomUUID();
        final Long accountRecordId = 19384012L;
        ImmutableAccountData immutableAccountData = (ImmutableAccountData)Mockito.mock(ImmutableAccountData.class);
        Mockito.when((Object)this.immutableAccountInternalApi.getImmutableAccountDataByRecordId((Long)Mockito.eq((Object)accountRecordId), (InternalTenantContext)Mockito.any())).thenReturn((Object)immutableAccountData);
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.execute("insert into accounts (record_id, id, email, name, first_name_length, time_zone, is_notified_for_invoices, created_date, created_by, updated_date, updated_by) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{accountRecordId, accountId.toString(), "yo@t.com", "toto", 4, "UTC", false, new Date(), "i", new Date(), "j"});
                return null;
            }
        });
        this.checkPagination(0L);
        String cfName = UUID.randomUUID().toString().substring(1, 4);
        String cfValue = UUID.randomUUID().toString().substring(1, 4);
        StringCustomField customField = new StringCustomField(cfName, cfValue, ObjectType.ACCOUNT, accountId, this.callContext.getCreatedDate());
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.CUSTOM_FIELD);
        this.customFieldUserApi.addCustomFields((List)ImmutableList.of((Object)customField), this.callContext);
        this.assertListenerStatus();
        this.checkPagination(1L);
        List customFields = this.customFieldUserApi.getCustomFieldsForObject(accountId, ObjectType.ACCOUNT, (TenantContext)this.callContext);
        Assert.assertEquals((int)customFields.size(), (int)1);
        Assert.assertEquals((String)((CustomField)customFields.get(0)).getFieldName(), (String)customField.getFieldName());
        Assert.assertEquals((String)((CustomField)customFields.get(0)).getFieldValue(), (String)customField.getFieldValue());
        Assert.assertEquals((Object)((CustomField)customFields.get(0)).getObjectId(), (Object)customField.getObjectId());
        Assert.assertEquals((Object)((CustomField)customFields.get(0)).getObjectType(), (Object)customField.getObjectType());
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                List values = handle.select("select account_record_id from custom_fields where object_id = ?", new Object[]{accountId.toString()});
                Assert.assertEquals((int)values.size(), (int)1);
                Assert.assertEquals((int)((Map)values.get(0)).keySet().size(), (int)1);
                Assert.assertEquals((Object)Long.valueOf(((Map)values.get(0)).get("account_record_id").toString()), (Object)accountRecordId);
                return null;
            }
        });
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.CUSTOM_FIELD);
        this.customFieldUserApi.removeCustomFields(customFields, this.callContext);
        this.assertListenerStatus();
        List remainingCustomFields = this.customFieldUserApi.getCustomFieldsForObject(accountId, ObjectType.ACCOUNT, (TenantContext)this.callContext);
        Assert.assertEquals((int)remainingCustomFields.size(), (int)0);
        this.checkPagination(0L);
        StringCustomField newCustomField = new StringCustomField(cfName, cfValue, ObjectType.ACCOUNT, accountId, this.callContext.getCreatedDate());
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.CUSTOM_FIELD);
        this.customFieldUserApi.addCustomFields((List)ImmutableList.of((Object)newCustomField), this.callContext);
        this.assertListenerStatus();
        remainingCustomFields = this.customFieldUserApi.getCustomFieldsForObject(accountId, ObjectType.ACCOUNT, (TenantContext)this.callContext);
        Assert.assertEquals((int)remainingCustomFields.size(), (int)1);
        this.checkPagination(1L);
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.CUSTOM_FIELD);
        this.customFieldUserApi.removeCustomFields(remainingCustomFields, this.callContext);
        this.assertListenerStatus();
        remainingCustomFields = this.customFieldUserApi.getCustomFieldsForObject(accountId, ObjectType.ACCOUNT, (TenantContext)this.callContext);
        Assert.assertEquals((int)remainingCustomFields.size(), (int)0);
        this.checkPagination(0L);
    }

    private void checkPagination(long nbRecords) {
        Pagination foundCustomFields = this.customFieldUserApi.searchCustomFields("ACCOUNT", Long.valueOf(0L), Long.valueOf(nbRecords + 1L), (TenantContext)this.callContext);
        Assert.assertEquals((boolean)foundCustomFields.iterator().hasNext(), (nbRecords > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)foundCustomFields.getMaxNbRecords(), (Object)nbRecords);
        Assert.assertEquals((Object)foundCustomFields.getTotalNbRecords(), (Object)nbRecords);
        Pagination gotCustomFields = this.customFieldUserApi.getCustomFields(Long.valueOf(0L), Long.valueOf(nbRecords + 1L), (TenantContext)this.callContext);
        Assert.assertEquals((boolean)gotCustomFields.iterator().hasNext(), (nbRecords > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)gotCustomFields.getMaxNbRecords(), (Object)nbRecords);
        Assert.assertEquals((Object)gotCustomFields.getTotalNbRecords(), (Object)nbRecords);
    }
}

