/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.dao;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GregorianChronology;
import org.mariadb.jdbc.MySQLDataSource;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestDateInvestigation {
    private static final TimeZone TZ__GMT = TimeZone.getTimeZone("GMT");
    private static final DateTimeZone DATE_TZ_GMT = DateTimeZone.forTimeZone((TimeZone)TZ__GMT);
    private static final Calendar GMT_CALENDAR = Calendar.getInstance();
    private static final TimeZone TZ_PLUS_8_GMT = TimeZone.getTimeZone("GMT+8:00");
    private static final DateTimeZone DATE_TZ_PLUS_8_GMT = DateTimeZone.forTimeZone((TimeZone)TZ_PLUS_8_GMT);
    private static final Calendar CALENDAR_PLUS_8_GMT = Calendar.getInstance(TZ_PLUS_8_GMT);
    private static final TimeZone TZ_MINUS_20_GMT = TimeZone.getTimeZone("GMT-20:00");
    private static final DateTimeZone DATE_TZ_MINUS_20_GMT = DateTimeZone.forTimeZone((TimeZone)TZ_MINUS_20_GMT);
    private static final Calendar CALENDAR_MINUS_20_GMT = Calendar.getInstance(TZ_MINUS_20_GMT);
    private Connection connection;
    private DataSource rawSource;

    @BeforeTest(groups={"slow"})
    public void beforeTest() throws SQLException {
        this.rawSource = this.getRawSource(DataSourceType.MYSQL_MARIADB, "killbill", "root", "root");
    }

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws SQLException {
        this.connection = this.rawSource.getConnection();
        this.cleanup();
    }

    @AfterMethod(groups={"slow"})
    public void afterMethod() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    @Test(groups={"slow"}, enabled=false)
    public void testWithGMTPlus8() throws SQLException {
        LocalDate date1_1 = new LocalDate(2014, 10, 1, (Chronology)GregorianChronology.getInstance((DateTimeZone)DATE_TZ_PLUS_8_GMT));
        DateTime date2_1 = new DateTime(2014, 10, 1, 22, 48, 56, DATE_TZ_PLUS_8_GMT);
        this.insertData(date1_1, date2_1, date2_1);
        FullOfDates result = this.readData();
        Assert.assertEquals((int)result.getDate1().compareTo((ReadablePartial)date1_1), (int)0);
        Assert.assertEquals((int)result.getDate2().compareTo((ReadableInstant)date2_1), (int)0);
        Assert.assertEquals((String)result.getDate2().getZone().toString(), (String)"UTC");
    }

    @Test(groups={"slow"}, enabled=false)
    public void testWithGMTMinus20() throws SQLException {
        LocalDate date1_1 = new LocalDate(2014, 10, 1, (Chronology)GregorianChronology.getInstance((DateTimeZone)DATE_TZ_MINUS_20_GMT));
        DateTime date2_1 = new DateTime(2014, 10, 1, 16, 48, 56, DATE_TZ_MINUS_20_GMT);
        this.insertData(date1_1, date2_1, date2_1);
        FullOfDates result = this.readData();
        Assert.assertEquals((int)result.getDate1().compareTo((ReadablePartial)date1_1), (int)0);
        Assert.assertEquals((int)result.getDate2().compareTo((ReadableInstant)date2_1), (int)0);
        Assert.assertEquals((String)result.getDate2().getZone().toString(), (String)"UTC");
    }

    private void cleanup() throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("delete from full_of_dates;");
        try {
            stmt.execute();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FullOfDates readData() throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("select * from full_of_dates");
        try {
            ResultSet rs = stmt.executeQuery();
            rs.next();
            String dateString = rs.getString(2);
            LocalDate d1 = new LocalDate((Object)dateString, DateTimeZone.UTC);
            Timestamp t2 = rs.getTimestamp(3);
            DateTime d2 = new DateTime(t2.getTime(), DateTimeZone.UTC);
            FullOfDates fullOfDates = new FullOfDates(d1, d2, null);
            return fullOfDates;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertData(LocalDate date1, DateTime date2, DateTime date3) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("insert into full_of_dates (date1, datetime1, timestamp1) VALUES (?, ?, ?)");
        try {
            if (date1 != null) {
                stmt.setString(1, date1.toString());
            }
            if (date2 != null) {
                stmt.setTimestamp(2, new Timestamp(date2.toDate().getTime()));
            }
            stmt.setTimestamp(3, new Timestamp(new DateTime().toDate().getTime()));
            stmt.execute();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private DataSource getRawSource(DataSourceType type, String dbName, String user, String pwd) throws SQLException {
        if (type == DataSourceType.MYSQL_JDBC2) {
            return this.getRawMysqlDataSource(dbName, user, pwd);
        }
        if (type == DataSourceType.MYSQL_MARIADB) {
            return this.getRawMariaDBDataSource(dbName, user, pwd);
        }
        throw new IllegalStateException("Unknow data source " + (Object)((Object)type));
    }

    private DataSource getRawMysqlDataSource(String dbName, String user, String pwd) {
        MysqlDataSource rawSource = new MysqlDataSource();
        rawSource.setDatabaseName(dbName);
        rawSource.setUser(user);
        rawSource.setPassword(pwd);
        rawSource.setPort(3306);
        rawSource.setURL("jdbc:mysql://localhost:3306/killbill?createDatabaseIfNotExist=true&allowMultiQueries=true");
        return rawSource;
    }

    private DataSource getRawMariaDBDataSource(String dbName, String user, String pwd) throws SQLException {
        MySQLDataSource rawSource = new MySQLDataSource();
        rawSource.setURL("jdbc:mysql://localhost:3306/killbill?createDatabaseIfNotExist=true&allowMultiQueries=true");
        rawSource.setDatabaseName(dbName);
        rawSource.setUser(user);
        rawSource.setPassword(pwd);
        rawSource.setPort(3306);
        return rawSource;
    }

    private static class FullOfDates {
        private final LocalDate date1;
        private final DateTime date2;
        private final DateTime date3;

        public FullOfDates(LocalDate date1, DateTime date2, DateTime date3) {
            this.date1 = date1;
            this.date2 = date2;
            this.date3 = date3;
        }

        public LocalDate getDate1() {
            return this.date1;
        }

        public DateTime getDate2() {
            return this.date2;
        }

        public DateTime getDate3() {
            return this.date3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DataSourceType {
        MYSQL_JDBC2,
        MYSQL_MARIADB;

    }
}

