/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.dao;

import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNonEntityDao
extends UtilTestSuiteWithEmbeddedDB {
    final Long tenantRecordId = 123123123L;
    final UUID tenantId = UUID.fromString("121c59d4-0458-4038-a683-698c9a121c12");
    final UUID accountId = UUID.fromString("a01c59d4-0458-4038-a683-698c9a121c69");
    final Long accountRecordId = 333333L;
    final UUID tagDefinitionId = UUID.fromString("e01c59d4-0458-4038-a683-698c9a121c34");
    final Long tagDefinitionRecordId = 44444444L;
    final UUID tagId = UUID.fromString("123c59d4-0458-4038-a683-698c9a121456");
    final Long tagRecordId = 55555555L;

    @Test(groups={"slow"})
    public void testRetrieveRecordIdFromObject() throws IOException {
        this.insertAccount();
        Long resultRecordId = this.nonEntityDao.retrieveRecordIdFromObject(this.accountId, ObjectType.ACCOUNT, null);
        Assert.assertEquals((Object)resultRecordId, (Object)this.accountRecordId);
    }

    @Test(groups={"slow"})
    public void testRetrieveAccountRecordIdFromAccountObject() throws IOException {
        this.insertAccount();
        Long resultAccountRecordId = this.nonEntityDao.retrieveAccountRecordIdFromObject(this.accountId, ObjectType.ACCOUNT, null);
        Assert.assertEquals((Object)resultAccountRecordId, (Object)this.accountRecordId);
    }

    @Test(groups={"slow"})
    public void testRetrieveAccountRecordIdFromTagDefinitionObject() throws IOException {
        this.insertTagDefinition();
        Long resultAccountRecordId = this.nonEntityDao.retrieveAccountRecordIdFromObject(this.tagDefinitionId, ObjectType.TAG_DEFINITION, null);
        Assert.assertEquals((Object)resultAccountRecordId, null);
    }

    @Test(groups={"slow"})
    public void testRetrieveAccountRecordIdFromOtherObject() throws IOException {
        this.insertTag();
        Long resultAccountRecordId = this.nonEntityDao.retrieveAccountRecordIdFromObject(this.tagId, ObjectType.TAG, null);
        Assert.assertEquals((Object)resultAccountRecordId, (Object)this.accountRecordId);
    }

    @Test(groups={"slow"})
    public void testRetrieveTenantRecordIdFromObject() throws IOException {
        this.insertAccount();
        Long resultTenantRecordId = this.nonEntityDao.retrieveTenantRecordIdFromObject(this.accountId, ObjectType.ACCOUNT, null);
        Assert.assertEquals((Object)resultTenantRecordId, (Object)this.tenantRecordId);
    }

    @Test(groups={"slow"})
    public void testRetrieveTenantRecordIdFromTenantObject() throws IOException {
        this.insertTenant();
        Long resultTenantRecordId = this.nonEntityDao.retrieveTenantRecordIdFromObject(this.tenantId, ObjectType.TENANT, null);
        Assert.assertEquals((Object)resultTenantRecordId, (Object)this.tenantRecordId);
    }

    private void insertAccount() throws IOException {
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.execute("insert into accounts (record_id, id, email, name, first_name_length, time_zone, is_notified_for_invoices, created_date, created_by, updated_date, updated_by, tenant_record_id) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{TestNonEntityDao.this.accountRecordId, TestNonEntityDao.this.accountId.toString(), "zozo@tt.com", "zozo", 4, "UTC", false, new Date(), "i", new Date(), "j", TestNonEntityDao.this.tenantRecordId});
                return null;
            }
        });
    }

    private void insertHistoryAccount() throws IOException {
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.execute("insert into account_history (record_id, id, email, name, first_name_length, time_zone, is_notified_for_invoices, created_date, created_by, updated_date, updated_by, tenant_record_id) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{TestNonEntityDao.this.accountRecordId, TestNonEntityDao.this.accountId.toString(), "zozo@tt.com", "zozo", 4, "UTC", false, new Date(), "i", new Date(), "j", TestNonEntityDao.this.tenantRecordId});
                return null;
            }
        });
    }

    private void insertTagDefinition() throws IOException {
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.execute("insert into tag_definitions (record_id, id, name, description, is_active, created_date, created_by, updated_date, updated_by, tenant_record_id) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{TestNonEntityDao.this.tagDefinitionRecordId, TestNonEntityDao.this.tagDefinitionId.toString(), "tagdef", "nothing", true, new Date(), "i", new Date(), "j", 0});
                return null;
            }
        });
    }

    private void insertTag() throws IOException {
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.execute("insert into tags (record_id, id, tag_definition_id, object_id, object_type, is_active, created_date, created_by, updated_date, updated_by, account_record_id, tenant_record_id) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{TestNonEntityDao.this.tagRecordId, TestNonEntityDao.this.tagId.toString(), TestNonEntityDao.this.tagDefinitionId.toString(), TestNonEntityDao.this.accountId.toString(), "ACCOUNT", true, new Date(), "i", new Date(), "j", TestNonEntityDao.this.accountRecordId, 0});
                return null;
            }
        });
    }

    private void insertTenant() throws IOException {
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.execute("insert into tenants (record_id, id, external_key, api_key, api_secret, api_salt, created_date, created_by, updated_date, updated_by) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{TestNonEntityDao.this.tenantRecordId, TestNonEntityDao.this.tenantId.toString(), "foo", "key", "secret", "salt", new Date(), "i", new Date(), "j"});
                return null;
            }
        });
    }
}

