/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.dao;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.killbill.billing.api.TestApiListener;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;
import org.killbill.billing.util.tag.dao.TagDefinitionSqlDao;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPagination
extends UtilTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"}, description="Test Pagination: basic SqlDAO and DAO calls")
    public void testTagDefinitionsPagination() throws Exception {
        ImmutableList tagDefinitions;
        int i;
        TagDefinitionSqlDao tagDefinitionSqlDao = (TagDefinitionSqlDao)this.dbi.onDemand(TagDefinitionSqlDao.class);
        for (i = 0; i < 10; ++i) {
            String definitionName = "name-" + i;
            String description = "description-" + i;
            this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
            this.tagDefinitionDao.create(definitionName, description, (InternalCallContext)this.internalCallContext);
            this.assertListenerStatus();
        }
        Assert.assertEquals((int)ImmutableList.copyOf((Iterator)tagDefinitionSqlDao.getAll((InternalTenantContext)this.internalCallContext)).size(), (int)10);
        Assert.assertEquals((int)ImmutableList.copyOf((Iterator)tagDefinitionSqlDao.get(Long.valueOf(0L), Long.valueOf(100L), "record_id", "asc", (InternalTenantContext)this.internalCallContext)).size(), (int)10);
        Assert.assertEquals((int)ImmutableList.copyOf((Iterator)tagDefinitionSqlDao.get(Long.valueOf(5L), Long.valueOf(100L), "record_id", "asc", (InternalTenantContext)this.internalCallContext)).size(), (int)5);
        Assert.assertEquals((int)ImmutableList.copyOf((Iterator)tagDefinitionSqlDao.get(Long.valueOf(5L), Long.valueOf(10L), "record_id", "asc", (InternalTenantContext)this.internalCallContext)).size(), (int)5);
        Assert.assertEquals((int)ImmutableList.copyOf((Iterator)tagDefinitionSqlDao.get(Long.valueOf(0L), Long.valueOf(5L), "record_id", "asc", (InternalTenantContext)this.internalCallContext)).size(), (int)5);
        for (i = 0; i < 10; ++i) {
            tagDefinitions = ImmutableList.copyOf((Iterator)tagDefinitionSqlDao.get(Long.valueOf(0L), Long.valueOf(i), "record_id", "asc", (InternalTenantContext)this.internalCallContext));
            Assert.assertEquals((int)tagDefinitions.size(), (int)i);
            for (int j = 0; j < tagDefinitions.size(); ++j) {
                Assert.assertEquals((String)((TagDefinitionModelDao)tagDefinitions.get(j)).getName(), (String)("name-" + j));
                Assert.assertEquals((String)((TagDefinitionModelDao)tagDefinitions.get(j)).getDescription(), (String)("description-" + j));
            }
        }
        Assert.assertEquals((int)ImmutableList.copyOf((Iterable)this.tagDefinitionDao.getAll((InternalTenantContext)this.internalCallContext)).size(), (int)10);
        Assert.assertEquals((int)ImmutableList.copyOf((Iterable)this.tagDefinitionDao.get(Long.valueOf(0L), Long.valueOf(100L), (InternalTenantContext)this.internalCallContext)).size(), (int)10);
        Assert.assertEquals((int)ImmutableList.copyOf((Iterable)this.tagDefinitionDao.get(Long.valueOf(5L), Long.valueOf(100L), (InternalTenantContext)this.internalCallContext)).size(), (int)5);
        Assert.assertEquals((int)ImmutableList.copyOf((Iterable)this.tagDefinitionDao.get(Long.valueOf(5L), Long.valueOf(10L), (InternalTenantContext)this.internalCallContext)).size(), (int)5);
        Assert.assertEquals((int)ImmutableList.copyOf((Iterable)this.tagDefinitionDao.get(Long.valueOf(0L), Long.valueOf(5L), (InternalTenantContext)this.internalCallContext)).size(), (int)5);
        for (i = 0; i < 10; ++i) {
            tagDefinitions = ImmutableList.copyOf((Iterable)this.tagDefinitionDao.get(Long.valueOf(0L), Long.valueOf(i), (InternalTenantContext)this.internalCallContext));
            Assert.assertEquals((int)tagDefinitions.size(), (int)i);
            for (int j = 0; j < tagDefinitions.size(); ++j) {
                Assert.assertEquals((String)((TagDefinitionModelDao)tagDefinitions.get(j)).getName(), (String)("name-" + j));
                Assert.assertEquals((String)((TagDefinitionModelDao)tagDefinitions.get(j)).getDescription(), (String)("description-" + j));
            }
        }
    }
}

