/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.dao;

import java.util.regex.Pattern;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.stringtemplate.v4.STGroupFile;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStringTemplateInheritance
extends UtilTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testCheckQueries() throws Exception {
        STGroupFile kombucha = new STGroupFile(this.getClass().getResource("/org/killbill/billing/util/dao/Kombucha.sql.stg"), "UTF-8", '<', '>');
        Assert.assertEquals((String)kombucha.getInstanceOf("isIsTimeForKombucha").render(), (String)"select hour(current_timestamp(0)) = 17 as is_time;");
        this.assertPattern(kombucha.getInstanceOf("getById").render(), "select\r?\n  t.record_id\r?\n, t.id\r?\n, t.tea\r?\n, t.mushroom\r?\n, t.sugar\r?\n, t.account_record_id\r?\n, t.tenant_record_id\r?\nfrom kombucha t\r?\nwhere t.id = :id\r?\nand t.tenant_record_id = :tenantRecordId\r?\n;");
        this.assertPattern(kombucha.getInstanceOf("getByRecordId").render(), "select\r?\n  t.record_id\r?\n, t.id\r?\n, t.tea\r?\n, t.mushroom\r?\n, t.sugar\r?\n, t.account_record_id\r?\n, t.tenant_record_id\r?\nfrom kombucha t\r?\nwhere t.record_id = :recordId\r?\nand t.tenant_record_id = :tenantRecordId\r?\n;");
        this.assertPattern(kombucha.getInstanceOf("getRecordId").render(), "select\r?\n  t.record_id\r?\nfrom kombucha t\r?\nwhere t.id = :id\r?\nand t.tenant_record_id = :tenantRecordId\r?\n;");
        this.assertPattern(kombucha.getInstanceOf("getHistoryRecordId").render(), "select\r?\n  max\\(t.record_id\\)\r?\nfrom kombucha_history t\r?\nwhere t.target_record_id = :targetRecordId\r?\nand t.tenant_record_id = :tenantRecordId\r?\n;");
        this.assertPattern(kombucha.getInstanceOf("getAll").render(), "select\r?\n  t.record_id\r?\n, t.id\r?\n, t.tea\r?\n, t.mushroom\r?\n, t.sugar\r?\n, t.account_record_id\r?\n, t.tenant_record_id\r?\nfrom kombucha t\r?\nwhere t.tenant_record_id = :tenantRecordId\r?\norder by t.record_id ASC\r?\n;");
        this.assertPattern(kombucha.getInstanceOf("get").add("orderBy", (Object)"record_id").add("offset", (Object)"3").add("rowCount", (Object)"12").add("ordering", (Object)"ASC").render(), "select\r?\n  t.record_id\r?\n, t.id\r?\n, t.tea\r?\n, t.mushroom\r?\n, t.sugar\r?\n, t.account_record_id\r?\n, t.tenant_record_id\r?\nfrom kombucha t\r?\njoin \\(\r?\n  select record_id\r?\n  from kombucha\r?\n  where tenant_record_id = :tenantRecordId\r?\n  order by record_id ASC\r?\n  limit :rowCount offset :offset\r?\n\\) optimization on optimization.record_id = t.record_id\r?\norder by t.record_id ASC\r?\n;");
        this.assertPattern(kombucha.getInstanceOf("test").render(), "select\r?\n  t.record_id\r?\n, t.id\r?\n, t.tea\r?\n, t.mushroom\r?\n, t.sugar\r?\n, t.account_record_id\r?\n, t.tenant_record_id\r?\nfrom kombucha t\r?\nwhere t.tenant_record_id = :tenantRecordId\r?\nlimit 1\r?\n;");
        this.assertPattern(kombucha.getInstanceOf("addHistoryFromTransaction").render(), "insert into kombucha_history \\(\r?\n  id\r?\n, target_record_id\r?\n, change_type\r?\n, tea\r?\n, mushroom\r?\n, sugar\r?\n, account_record_id\r?\n, tenant_record_id\r?\n\\)\r?\nvalues \\(\r?\n  :id\r?\n, :targetRecordId\r?\n, :changeType\r?\n, :tea\r?\n, :mushroom\r?\n, :sugar\r?\n, :accountRecordId\r?\n, :tenantRecordId\r?\n\\)\r?\n;");
        this.assertPattern(kombucha.getInstanceOf("insertAuditFromTransaction").render(), "insert into audit_log \\(\r?\nid\r?\n, table_name\r?\n, target_record_id\r?\n, change_type\r?\n, created_by\r?\n, reason_code\r?\n, comments\r?\n, user_token\r?\n, created_date\r?\n, account_record_id\r?\n, tenant_record_id\r?\n\\)\r?\nvalues \\(\r?\n  :id\r?\n, :tableName\r?\n, :targetRecordId\r?\n, :changeType\r?\n, :createdBy\r?\n, :reasonCode\r?\n, :comments\r?\n, :userToken\r?\n, :createdDate\r?\n, :accountRecordId\r?\n, :tenantRecordId\r?\n\\)\r?\n;");
    }

    private void assertPattern(String actual, String expected) {
        Assert.assertTrue((boolean)Pattern.compile(expected).matcher(actual).find(), (String)String.format("Expected to see:\n%s\nin:\n%s", expected, actual));
    }
}

