/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.email;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.template.translation.DefaultCatalogTranslator;
import org.killbill.xmlloader.UriAccessor;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DefaultCatalogTranslationTest
extends UtilTestSuiteNoDB {
    @BeforeClass(groups={"fast"})
    public void beforeClass() throws Exception {
        super.beforeClass();
    }

    private ResourceBundle getBundle(Locale locale) throws IOException, URISyntaxException {
        String propertiesFileNameWithCountry = "org/killbill/billing/util/template/translation/CatalogTranslation_" + locale.getLanguage() + "_" + locale.getCountry() + ".properties";
        InputStream inputStream = UriAccessor.accessUri((String)propertiesFileNameWithCountry);
        if (inputStream == null) {
            return null;
        }
        return new PropertyResourceBundle(inputStream);
    }

    @Test(groups={"fast"})
    public void testBundle_us() throws IOException, URISyntaxException {
        String shotgunMonthly = "shotgun-monthly";
        String shotgunAnnual = "shotgun-annual";
        String badText = "Bad text";
        ResourceBundle bundle_en_US = this.getBundle(Locale.US);
        DefaultCatalogTranslator translation = new DefaultCatalogTranslator(bundle_en_US, null);
        Assert.assertEquals((String)translation.getTranslation("shotgun-monthly"), (String)"Monthly shotgun plan");
        Assert.assertEquals((String)translation.getTranslation("shotgun-annual"), (String)"Annual shotgun plan");
        Assert.assertEquals((String)translation.getTranslation("Bad text"), (String)"Bad text");
    }

    @Test(groups={"fast"})
    public void testBundle_ca_fr() throws IOException, URISyntaxException {
        String shotgunMonthly = "shotgun-monthly";
        String shotgunAnnual = "shotgun-annual";
        String badText = "Bad text";
        ResourceBundle bundle_ca_fr = this.getBundle(Locale.CANADA_FRENCH);
        DefaultCatalogTranslator translation = new DefaultCatalogTranslator(bundle_ca_fr, null);
        Assert.assertEquals((String)translation.getTranslation("shotgun-monthly"), (String)"Fusil de chasse mensuel");
        Assert.assertEquals((String)translation.getTranslation("shotgun-annual"), (String)"Fusil de chasse annuel");
        Assert.assertEquals((String)translation.getTranslation("Bad text"), (String)"Bad text");
    }

    @Test(groups={"fast"})
    public void testBundle_ch() throws IOException, URISyntaxException {
        String shotgunMonthly = "shotgun-monthly";
        String shotgunAnnual = "shotgun-annual";
        String badText = "Bad text";
        DefaultCatalogTranslator translation = new DefaultCatalogTranslator(null, null);
        Assert.assertEquals((String)translation.getTranslation("shotgun-monthly"), (String)"shotgun-monthly");
        Assert.assertEquals((String)translation.getTranslation("shotgun-annual"), (String)"shotgun-annual");
        Assert.assertEquals((String)translation.getTranslation("Bad text"), (String)"Bad text");
    }
}

