/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity.dao;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.entity.DefaultPagination;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.EntityDao;
import org.killbill.billing.util.entity.dao.EntityModelDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockEntityDaoBase<M extends EntityModelDao<E>, E extends Entity, U extends BillingExceptionBase>
implements EntityDao<M, E, U> {
    protected static final AtomicLong autoIncrement = new AtomicLong(1L);
    protected final Map<UUID, Map<Long, M>> entities = new HashMap<UUID, Map<Long, M>>();

    public void create(M entity, InternalCallContext context) throws U {
        this.entities.put(entity.getId(), (Map<Long, M>)ImmutableMap.of((Object)autoIncrement.incrementAndGet(), entity));
    }

    public Long getRecordId(UUID id, InternalTenantContext context) {
        return this.entities.get(id).keySet().iterator().next();
    }

    public M getByRecordId(Long recordId, InternalTenantContext context) {
        for (Map<Long, M> cur : this.entities.values()) {
            if (!cur.keySet().iterator().next().equals(recordId)) continue;
            cur.values().iterator().next();
        }
        return null;
    }

    public M getById(UUID id, InternalTenantContext context) {
        return (M)((EntityModelDao)this.entities.get(id).values().iterator().next());
    }

    public Pagination<M> getAll(InternalTenantContext context) {
        ArrayList<M> result = new ArrayList<M>();
        for (Map<Long, M> cur : this.entities.values()) {
            result.add(cur.values().iterator().next());
        }
        return new DefaultPagination(this.getCount(context), result.iterator());
    }

    public Pagination<M> get(Long offset, Long limit, InternalTenantContext context) {
        return DefaultPagination.build((Long)offset, (Long)limit, (Collection)ImmutableList.copyOf(this.getAll(context)));
    }

    public Long getCount(InternalTenantContext context) {
        return this.entities.keySet().size();
    }

    public void update(M entity, InternalCallContext context) {
        Long entityRecordId = this.getRecordId(entity.getId(), (InternalTenantContext)context);
        this.entities.get(entity.getId()).put(entityRecordId, entity);
    }

    public void delete(M entity, InternalCallContext context) {
        this.entities.remove(entity.getId());
    }

    public void test(InternalTenantContext context) {
    }
}

