/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.export.dao;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.export.dao.CSVExportOutputStream;
import org.killbill.billing.util.validation.DefaultColumnInfo;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCSVExportOutputStream
extends UtilTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testSimpleGenerator() throws Exception {
        CSVExportOutputStream out = new CSVExportOutputStream((OutputStream)new ByteArrayOutputStream());
        String tableName = UUID.randomUUID().toString();
        out.newTable(tableName, (List)ImmutableList.of((Object)new DefaultColumnInfo(tableName, "first_name", Long.valueOf(0L), Long.valueOf(0L), true, Long.valueOf(0L), "varchar"), (Object)new DefaultColumnInfo(tableName, "last_name", Long.valueOf(0L), Long.valueOf(0L), true, Long.valueOf(0L), "varchar"), (Object)new DefaultColumnInfo(tableName, "age", Long.valueOf(0L), Long.valueOf(0L), true, Long.valueOf(0L), "tinyint")));
        out.write((Map)ImmutableMap.of((Object)"first_name", (Object)"jean", (Object)"last_name", (Object)"dupond", (Object)"age", (Object)35));
        out.write((Map)ImmutableMap.of((Object)"last_name", (Object)"dujardin", (Object)"first_name", (Object)"jack", (Object)"age", (Object)40));
        out.write((Map)ImmutableMap.of((Object)"age", (Object)12, (Object)"first_name", (Object)"pierre", (Object)"last_name", (Object)"schmitt"));
        out.write((Map)ImmutableMap.of((Object)"first_name", (Object)"stephane", (Object)"last_name", (Object)"dupont", (Object)"age", (Object)"30"));
        Assert.assertEquals((String)out.toString(), (String)("-- " + tableName + " first_name|last_name|age\njean|dupond|35\njack|dujardin|40\npierre|schmitt|12\nstephane|dupont|30\n"));
    }
}

