/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.export.dao;

import com.ning.compress.lzf.LZFEncoder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.UUID;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.api.DatabaseExportOutputStream;
import org.killbill.billing.util.export.dao.CSVExportOutputStream;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDatabaseExportDao
extends UtilTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testExportSimpleData() throws Exception {
        String dump = this.getDump();
        Assert.assertEquals((String)dump, (String)"");
        final String accountId = UUID.randomUUID().toString();
        final String accountEmail = UUID.randomUUID().toString().substring(0, 4) + '@' + UUID.randomUUID().toString().substring(0, 4);
        final String accountName = UUID.randomUUID().toString().substring(0, 4);
        int firstNameLength = 4;
        String timeZone = "UTC";
        boolean isNotifiedForInvoices = false;
        final Date createdDate = new Date(12421982000L);
        final String createdBy = UUID.randomUUID().toString().substring(0, 4);
        final Date updatedDate = new Date(382910622000L);
        final String updatedBy = UUID.randomUUID().toString().substring(0, 4);
        final byte[] properties = LZFEncoder.encode((byte[])new byte[]{99, 97, 102, 101});
        String tableNameA = "test_database_export_dao_a";
        String tableNameB = "test_database_export_dao_b";
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.execute("drop table if exists test_database_export_dao_a", new Object[0]);
                handle.execute("create table test_database_export_dao_a(record_id serial unique,a_column char default 'a',blob_column mediumblob,account_record_id bigint /*! unsigned */ not null,tenant_record_id bigint /*! unsigned */ not null default 0,primary key(record_id));", new Object[0]);
                handle.execute("drop table if exists test_database_export_dao_b", new Object[0]);
                handle.execute("create table test_database_export_dao_b(record_id serial unique,b_column char default 'b',account_record_id bigint /*! unsigned */ not null,tenant_record_id bigint /*! unsigned */ not null default 0,primary key(record_id));", new Object[0]);
                handle.execute("insert into test_database_export_dao_a (blob_column, account_record_id, tenant_record_id) values (?, ?, ?)", new Object[]{properties, TestDatabaseExportDao.this.internalCallContext.getAccountRecordId(), TestDatabaseExportDao.this.internalCallContext.getTenantRecordId()});
                handle.execute("insert into test_database_export_dao_b (account_record_id, tenant_record_id) values (?, ?)", new Object[]{TestDatabaseExportDao.this.internalCallContext.getAccountRecordId(), TestDatabaseExportDao.this.internalCallContext.getTenantRecordId()});
                handle.execute("insert into accounts (record_id, id, email, name, first_name_length, time_zone, is_notified_for_invoices, created_date, created_by, updated_date, updated_by, tenant_record_id) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{TestDatabaseExportDao.this.internalCallContext.getAccountRecordId(), accountId, accountEmail, accountName, 4, "UTC", false, createdDate, createdBy, updatedDate, updatedBy, TestDatabaseExportDao.this.internalCallContext.getTenantRecordId()});
                return null;
            }
        });
        String newDump = this.getDump();
        Assert.assertEquals((String)newDump, (String)("-- accounts record_id|id|external_key|email|name|first_name_length|currency|billing_cycle_day_local|parent_account_id|is_payment_delegated_to_parent|payment_method_id|time_zone|locale|address1|address2|company_name|city|state_or_province|country|postal_code|phone|notes|migrated|is_notified_for_invoices|created_date|created_by|updated_date|updated_by|tenant_record_id\n" + String.format("%s|%s||%s|%s|%s||||false||%s|||||||||||false|%s|%s|%s|%s|%s|%s", this.internalCallContext.getAccountRecordId(), accountId, accountEmail, accountName, 4, "UTC", false, "1970-05-24T18:33:02.000+0000", createdBy, "1982-02-18T20:03:42.000+0000", updatedBy, this.internalCallContext.getTenantRecordId()) + "\n-- " + "test_database_export_dao_a" + " record_id|a_column|blob_column|account_record_id|tenant_record_id\n1|a|WlYAAARjYWZl|" + this.internalCallContext.getAccountRecordId() + "|" + this.internalCallContext.getTenantRecordId() + "\n-- " + "test_database_export_dao_b" + " record_id|b_column|account_record_id|tenant_record_id\n1|b|" + this.internalCallContext.getAccountRecordId() + "|" + this.internalCallContext.getTenantRecordId() + "\n"));
    }

    private String getDump() {
        CSVExportOutputStream out = new CSVExportOutputStream((OutputStream)new ByteArrayOutputStream());
        this.dao.exportDataForAccount((DatabaseExportOutputStream)out, (InternalTenantContext)this.internalCallContext);
        return out.toString();
    }
}

